/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.java_provisioner.api;

import java.io.File;
import net.minecraftforge.java_provisioner.JavaVersion;
import net.minecraftforge.java_provisioner.api.Util;

public interface IJavaInstall
extends Comparable<IJavaInstall> {
    public File home();

    public boolean isJdk();

    public int majorVersion();

    public String version();

    public String vendor();

    @Override
    default public int compareTo(IJavaInstall o2) {
        if (this.isJdk() != o2.isJdk()) {
            return this.isJdk() ? -1 : 1;
        }
        if (this.majorVersion() != o2.majorVersion()) {
            return o2.majorVersion() - this.majorVersion();
        }
        if (this.vendor() != null && o2.vendor() == null) {
            return -1;
        }
        if (this.vendor() == null && o2.vendor() != null) {
            return 1;
        }
        if (this.vendor() != null && !this.vendor().equals(o2.vendor())) {
            int v2;
            int v1 = Util.getVendorOrder(this.vendor());
            if (v1 == (v2 = Util.getVendorOrder(this.vendor()))) {
                if (v1 == -1) {
                    return this.vendor().compareTo(o2.vendor());
                }
            } else {
                if (v1 == -1) {
                    return 1;
                }
                if (v2 == -1) {
                    return -1;
                }
                return v1 - v2;
            }
        }
        if (this.version() != null && o2.version() == null) {
            return -1;
        }
        if (this.version() == null && o2.version() != null) {
            return 1;
        }
        if (this.version() != null && !this.version().equals(o2.version())) {
            JavaVersion v1 = JavaVersion.nullableParse(this.version());
            JavaVersion v2 = JavaVersion.nullableParse(o2.version());
            if (v1 == null && v2 != null) {
                return 1;
            }
            if (v1 != null && v2 == null) {
                return -1;
            }
            if (v1 == null) {
                return this.version().compareTo(o2.version());
            }
            return v2.compareTo(v1);
        }
        return 0;
    }
}

