/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.java_provisioner;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.java_provisioner.api.IJavaInstall;
import net.minecraftforge.java_provisioner.api.IJavaLocator;
import net.minecraftforge.java_provisioner.util.OS;
import net.minecraftforge.java_provisioner.util.ProcessUtils;

public class JavaHomeLocator
implements IJavaLocator {
    protected List<String> searched = new ArrayList<String>();

    @Override
    public File find(int version) {
        IJavaInstall result = this.fromEnv("JAVA_HOME_" + version + "_X64");
        if (result == null) {
            result = this.fromEnv("JAVA_HOME_" + version + "_arm64");
        }
        if (result == null) {
            result = this.fromEnv("JAVA_HOME_" + version);
        }
        if (result == null && (result = this.fromEnv("JAVA_HOME")) != null && result.majorVersion() != version) {
            this.log("  Wrong version: Was " + result.majorVersion() + " wanted " + version);
            result = null;
        }
        return result == null ? null : result.home();
    }

    @Override
    public List<IJavaInstall> findAll() {
        ArrayList<IJavaInstall> ret = new ArrayList<IJavaInstall>();
        for (String key : System.getenv().keySet()) {
            IJavaInstall tmp;
            if (!key.startsWith("JAVA_HOME") || (tmp = this.fromEnv(key)) == null) continue;
            ret.add(tmp);
        }
        return ret;
    }

    @Override
    public List<String> logOutput() {
        return this.searched;
    }

    protected void log(String line) {
        this.searched.add(line);
    }

    protected IJavaInstall fromEnv(String name) {
        String env = System.getenv(name);
        if (env == null) {
            this.log("Environment: \"" + name + "\" Empty");
            return null;
        }
        this.log("Environment: \"" + name + "\"");
        this.log("  Value: \"" + env + "\"");
        return this.fromPath(env);
    }

    protected IJavaInstall fromPath(String path) {
        return this.fromPath(new File(path));
    }

    protected IJavaInstall fromPath(File path) {
        File exe = new File(path, "bin/java" + OS.CURRENT.exe());
        if (!exe.exists()) {
            this.log("  Missing Executable");
            return null;
        }
        ProcessUtils.ProbeResult result = ProcessUtils.testJdk(path);
        if (result.exitCode != 0) {
            this.log("  Exit code: " + result.exitCode);
            for (String line : result.lines) {
                this.searched.add("  " + line);
            }
        }
        return result.meta;
    }
}

