/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.mcmaven.impl.GlobalOptions;
import net.minecraftforge.mcmaven.impl.mappings.Mappings;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.tasks.MCPNames;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.util.file.FileUtils;
import net.minecraftforge.util.hash.HashFunction;
import net.minecraftforge.util.hash.HashStore;
import net.minecraftforge.util.hash.HashUtils;
import org.apache.commons.io.IOUtils;

public final class RenameTask
implements Task {
    private final String name;
    private final MCPSide side;
    private final boolean javadocs;
    private final Task task;

    public RenameTask(File build, String name, MCPSide side, Task sources, Mappings mappings, boolean javadocs) {
        this.name = name;
        this.side = side;
        this.javadocs = javadocs;
        this.task = this.remapSources(sources, mappings.getFolder(build), mappings);
    }

    @Override
    public File execute() {
        return this.task.execute();
    }

    @Override
    public boolean resolved() {
        return this.task.resolved();
    }

    @Override
    public String name() {
        return this.task.name();
    }

    private Task remapSources(Task input, File outputDir, Mappings provider) {
        File output = new File(outputDir, !this.javadocs ? "remapped.jar" : "remapped-javadoc.jar");
        Task mappings = provider.getCsvZip(this.side);
        return Task.named("remap[" + this.name + "][" + String.valueOf(provider) + "]" + (!this.javadocs ? "" : "[javadoc]"), Task.deps(input, mappings), () -> RenameTask.remapSourcesImpl(input, mappings, output, this.javadocs));
    }

    private static File remapSourcesImpl(Task inputTask, Task mappingsTask, File output, boolean javadocs) {
        File input = inputTask.execute();
        File mappings = mappingsTask.execute();
        HashStore cache = HashStore.fromFile(output);
        cache.add("input", input);
        cache.add("mappings", mappings);
        cache.add("javadocs", javadocs ? "true" : "false");
        if (output.exists() && cache.isSame()) {
            return output;
        }
        GlobalOptions.assertNotCacheOnly();
        try {
            MCPNames names = MCPNames.load(mappings);
            FileUtils.ensureParent(output);
            try (ZipInputStream zin = new ZipInputStream(new FileInputStream(input));
                 ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(output));){
                ZipEntry entry = zin.getNextEntry();
                while (entry != null) {
                    zout.putNextEntry(FileUtils.getStableEntry(entry.getName()));
                    if (entry.getName().endsWith(".java")) {
                        String mapped = names.rename(zin, javadocs, javadocs);
                        IOUtils.write(mapped, (OutputStream)zout, StandardCharsets.UTF_8);
                    } else {
                        IOUtils.copy((InputStream)zin, (OutputStream)zout);
                    }
                    entry = zin.getNextEntry();
                }
            }
            HashUtils.updateHash(output, HashFunction.SHA1);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to rename sources for " + input.getAbsolutePath(), e);
        }
        cache.save();
        return output;
    }
}

