/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.java_provisioner.api;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.java_provisioner.DiscoLocator;
import net.minecraftforge.java_provisioner.GradleLocator;
import net.minecraftforge.java_provisioner.JavaDirectoryLocator;
import net.minecraftforge.java_provisioner.JavaHomeLocator;
import net.minecraftforge.java_provisioner.api.IJavaInstall;

public interface IJavaLocator {
    public File find(int var1);

    public List<IJavaInstall> findAll();

    public List<String> logOutput();

    default public IJavaInstall provision(int version) {
        return null;
    }

    public static IJavaLocator gradle() {
        return new GradleLocator();
    }

    public static IJavaLocator home() {
        return new JavaHomeLocator();
    }

    public static IJavaLocator paths() {
        return new JavaDirectoryLocator();
    }

    public static IJavaLocator paths(File ... dirs) {
        return new JavaDirectoryLocator(Arrays.asList(dirs));
    }

    public static IJavaLocator disco(File cache) {
        return new DiscoLocator(cache);
    }

    public static IJavaLocator disco(File cache, boolean offline) {
        return new DiscoLocator(cache, offline);
    }
}

