/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.util.file;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.Nullable;

public final class FileUtils {
    public static final long ZIPTIME = 628041600000L;
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    private FileUtils() {
    }

    public static ZipEntry getStableEntry(String name) {
        return FileUtils.getStableEntry(name, 628041600000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZipEntry getStableEntry(ZipEntry entry) {
        long time;
        TimeZone _default = TimeZone.getDefault();
        try {
            TimeZone.setDefault(GMT);
            time = entry.getTime();
        }
        finally {
            TimeZone.setDefault(_default);
        }
        return FileUtils.getStableEntry(entry.getName(), time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZipEntry getStableEntry(String name, long time) {
        ZipEntry ret = new ZipEntry(name);
        TimeZone _default = TimeZone.getDefault();
        try {
            TimeZone.setDefault(GMT);
            ret.setTime(time);
        }
        finally {
            TimeZone.setDefault(_default);
        }
        return ret;
    }

    public static JarEntry getStableEntryJar(String name) {
        return FileUtils.getStableEntryJar(name, 628041600000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JarEntry getStableEntryJar(JarEntry entry) {
        long time;
        TimeZone _default = TimeZone.getDefault();
        try {
            TimeZone.setDefault(GMT);
            time = entry.getTime();
        }
        finally {
            TimeZone.setDefault(_default);
        }
        return FileUtils.getStableEntryJar(entry.getName(), time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JarEntry getStableEntryJar(String name, long time) {
        JarEntry ret = new JarEntry(name);
        TimeZone _default = TimeZone.getDefault();
        try {
            TimeZone.setDefault(GMT);
            ret.setTime(time);
        }
        finally {
            TimeZone.setDefault(_default);
        }
        return ret;
    }

    public static List<File> listFiles(File path) {
        return FileUtils.listFiles(path, new ArrayList<File>());
    }

    private static List<File> listFiles(File dir, List<File> files) {
        if (!dir.exists()) {
            return files;
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Path must be directory: " + dir.getAbsolutePath());
        }
        for (File file : Objects.requireNonNull(dir.listFiles(), () -> "Failed to list files in " + dir.getAbsolutePath())) {
            if (file.isDirectory()) {
                files = FileUtils.listFiles(file, files);
                continue;
            }
            files.add(file);
        }
        return files;
    }

    public static void ensure(File path) {
        if (!path.isAbsolute()) {
            path = path.getAbsoluteFile();
        }
        if (!path.exists() && !path.getAbsoluteFile().mkdirs()) {
            throw new IllegalStateException("Failed to ensure existence of directory: " + path.getAbsolutePath());
        }
    }

    public static void ensureParent(File path) {
        FileUtils.ensure(path.getAbsoluteFile().getParentFile());
    }

    public static void mergeJars(File output, boolean stripSignatures, File ... files) throws IOException {
        FileUtils.mergeJars(output, stripSignatures, null, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeJars(File output, boolean stripSignatures, @Nullable BiPredicate<File, String> filter, File ... files) throws IOException {
        if (output.exists() && !output.delete()) {
            throw new IllegalStateException("Cannot merge jars, failed to delete existing output jar: " + output.getAbsolutePath());
        }
        FileUtils.ensureParent(output);
        ArrayList<ZipFile> zips = new ArrayList<ZipFile>();
        try {
            Info manifest = null;
            TreeMap<String, Info> signatures = new TreeMap<String, Info>();
            TreeMap<String, ByteArrayOutputStream> services = new TreeMap<String, ByteArrayOutputStream>();
            TreeMap<String, Info> entries = new TreeMap<String, Info>();
            for (File input : files) {
                ArrayList<Info> tmp = new ArrayList<Info>();
                if (input.isDirectory()) {
                    String prefix = input.getAbsolutePath();
                    for (File file : FileUtils.listFiles(input)) {
                        name = file.getAbsolutePath().substring(prefix.length()).replace('\\', '/');
                        if (filter != null && !filter.test(input, name)) continue;
                        tmp.add(new Info(name, file));
                    }
                } else {
                    ZipFile zip = new ZipFile(input);
                    zips.add(zip);
                    Enumeration<? extends ZipEntry> itr = zip.entries();
                    while (itr.hasMoreElements()) {
                        ZipEntry entry = itr.nextElement();
                        name = entry.getName();
                        if (entry.isDirectory() || filter != null && !filter.test(input, name)) continue;
                        tmp.add(new Info(name, () -> {
                            try {
                                return zip.getInputStream(entry);
                            }
                            catch (IOException e) {
                                return (InputStream)FileUtils.sneak(e);
                            }
                        }));
                    }
                }
                for (Info entry : tmp) {
                    if ("META-INF/MANIFEST.MF".equalsIgnoreCase(entry.name)) {
                        if (manifest != null) continue;
                        manifest = entry;
                        continue;
                    }
                    if (entry.name.startsWith("META-INF/services/")) {
                        ByteArrayOutputStream data = (ByteArrayOutputStream)services.get(entry.name);
                        if (data == null) {
                            data = new ByteArrayOutputStream();
                            services.put(entry.name, data);
                        } else {
                            data.write(10);
                        }
                        InputStream is = entry.stream.get();
                        try {
                            is.transferTo(data);
                            continue;
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                            continue;
                        }
                    }
                    if (FileUtils.isBlockOrSF(entry.name)) {
                        signatures.putIfAbsent(entry.name, entry);
                        continue;
                    }
                    entries.putIfAbsent(entry.name, entry);
                }
            }
            try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(output));){
                if (manifest != null) {
                    if (stripSignatures) {
                        FileUtils.writeStrippedManifest(zos, manifest);
                    } else {
                        FileUtils.writeEntry(zos, manifest);
                    }
                }
                if (!stripSignatures) {
                    for (Info info : signatures.values()) {
                        FileUtils.writeEntry(zos, info);
                    }
                }
                for (Map.Entry entry : services.entrySet()) {
                    zos.putNextEntry(FileUtils.getStableEntry((String)entry.getKey()));
                    zos.write(((ByteArrayOutputStream)entry.getValue()).toByteArray());
                    zos.closeEntry();
                }
                for (Info info : entries.values()) {
                    FileUtils.writeEntry(zos, info);
                }
            }
        }
        finally {
            for (ZipFile zip : zips) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static File makeJar(File classes, File sourcesDir, List<File> sources, File jar) {
        FileUtils.ensureParent(jar);
        try (JarOutputStream jos = new JarOutputStream(new FileOutputStream(jar));){
            List<File> classFiles = FileUtils.listFiles(classes);
            classFiles.sort(Comparator.comparing(File::getAbsolutePath));
            FileUtils.makeJarInternal(classes, classFiles, jos);
            sources.sort(Comparator.comparing(File::getAbsolutePath));
            FileUtils.makeJarInternal(sourcesDir, sources, jos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return jar;
    }

    public static void makeZip(File inputDir, File zip) {
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zip));){
            for (File file : FileUtils.listFiles(inputDir)) {
                String entryName = inputDir.toPath().relativize(file.toPath()).toString().replace('\\', '/');
                FileUtils.writeEntry(zos, new Info(entryName, file));
            }
        }
        catch (IOException e) {
            FileUtils.sneak(e);
        }
    }

    private static void makeJarInternal(File dir, List<File> classes, JarOutputStream jos) throws IOException {
        for (File file : classes) {
            String entryName = file.getAbsoluteFile().toString().substring(dir.getAbsolutePath().length() + 1).replace('\\', '/');
            FileUtils.writeEntry(jos, new Info(entryName, file));
        }
    }

    public static void splitJar(File raw, Set<String> whitelist, File output, boolean slim, boolean stable) throws IOException {
        try (ZipFile zin = new ZipFile(raw);
             FileOutputStream fos = new FileOutputStream(output);
             ZipOutputStream out = new ZipOutputStream(fos);){
            Enumeration<? extends ZipEntry> entries = zin.entries();
            while (entries.hasMoreElements()) {
                boolean isNotch;
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class") ? slim : slim != (isNotch = whitelist.contains(name.substring(0, name.length() - 6)))) continue;
                ZipEntry _new = FileUtils.getStableEntry(name, stable ? 628041600000L : 0L);
                out.putNextEntry(_new);
                try (InputStream ein = zin.getInputStream(entry);){
                    ein.transferTo(out);
                }
                out.closeEntry();
            }
        }
    }

    private static void writeEntry(ZipOutputStream zos, Info file) throws IOException {
        zos.putNextEntry(FileUtils.getStableEntry(file.name));
        file.stream.get().transferTo(zos);
        zos.closeEntry();
    }

    private static void writeStrippedManifest(ZipOutputStream zos, Info file) throws IOException {
        try (InputStream is = file.stream.get();){
            Manifest manifest = new Manifest(is);
            Iterator<Map.Entry<String, Attributes>> itr = manifest.getEntries().entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<String, Attributes> section = itr.next();
                Iterator<Map.Entry<Object, Object>> sItr = section.getValue().entrySet().iterator();
                while (sItr.hasNext()) {
                    Map.Entry<Object, Object> attribute = sItr.next();
                    String key = attribute.getKey().toString().toLowerCase(Locale.ROOT);
                    if (!key.endsWith("-digest")) continue;
                    sItr.remove();
                }
                if (!section.getValue().isEmpty()) continue;
                itr.remove();
            }
            zos.putNextEntry(FileUtils.getStableEntry(file.name));
            manifest.write(zos);
            zos.closeEntry();
        }
    }

    public static boolean isBlockOrSF(String path) {
        String s = path.toUpperCase(Locale.ENGLISH);
        if (!s.startsWith("META-INF/")) {
            return false;
        }
        return s.endsWith(".SF") || s.endsWith(".DSA") || s.endsWith(".RSA") || s.endsWith(".EC");
    }

    public static void deleteOnExit(File file) {
        if (!file.exists()) {
            return;
        }
        try (Stream<Path> walk = Files.walk(file.toPath(), new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEachOrdered(File::deleteOnExit);
        }
        catch (IOException e) {
            FileUtils.sneak(e);
        }
    }

    private static <R, E extends Throwable> R sneak(Throwable t) throws E {
        throw t;
    }

    private record Info(String name, Supplier<InputStream> stream) {
        private Info(String name, File file) {
            this(name, () -> {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    return (InputStream)FileUtils.sneak(e);
                }
            });
        }
    }
}

