/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.AbstractCsvCallbackHandler;
import de.siegmar.fastcsv.reader.FieldModifier;
import de.siegmar.fastcsv.reader.NamedCsvRecord;
import de.siegmar.fastcsv.reader.RecordWrapper;
import java.util.List;
import java.util.Objects;

public final class NamedCsvRecordHandler
extends AbstractCsvCallbackHandler<NamedCsvRecord> {
    private static final String[] EMPTY_HEADER = new String[0];
    private String[] header;

    public NamedCsvRecordHandler() {
    }

    public NamedCsvRecordHandler(List<String> header) {
        this.setHeader(header.toArray(new String[0]));
    }

    public NamedCsvRecordHandler(String ... header) {
        this.setHeader(header);
    }

    public NamedCsvRecordHandler(FieldModifier fieldModifier) {
        super(fieldModifier);
    }

    public NamedCsvRecordHandler(FieldModifier fieldModifier, List<String> header) {
        super(fieldModifier);
        this.setHeader(header.toArray(new String[0]));
    }

    public NamedCsvRecordHandler(FieldModifier fieldModifier, String ... header) {
        super(fieldModifier);
        this.setHeader(header);
    }

    private void setHeader(String ... header) {
        Objects.requireNonNull(header, "header must not be null");
        for (String h : header) {
            Objects.requireNonNull(h, "header must not be null");
        }
        this.header = (String[])header.clone();
    }

    @Override
    protected RecordWrapper<NamedCsvRecord> buildRecord() {
        if (this.comment) {
            return this.buildWrapper(new NamedCsvRecord(this.startingLineNumber, this.compactFields(), true, EMPTY_HEADER));
        }
        if (this.header == null) {
            this.setHeader(this.compactFields());
            return null;
        }
        return this.buildWrapper(new NamedCsvRecord(this.startingLineNumber, this.compactFields(), false, this.header));
    }
}

