/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.io;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import net.covers1624.quack.io.ConsumingOutputStream;
import net.covers1624.quack.io.NullOutputStream;

public class IndentPrintWriter
extends PrintWriter {
    public static final String DEFAULT_INDENT = "    ";
    private final PrintWriter delegate;
    private final String indentStr;
    private int indent = 0;

    public IndentPrintWriter(OutputStream os) {
        this(os, DEFAULT_INDENT);
    }

    public IndentPrintWriter(OutputStream os, String indentStr) {
        this(new PrintWriter(os, true), indentStr);
    }

    public IndentPrintWriter(PrintWriter delegate) {
        this(delegate, DEFAULT_INDENT);
    }

    public IndentPrintWriter(PrintWriter delegate, String indentStr) {
        super(NullOutputStream.INSTANCE, true);
        this.delegate = delegate;
        this.indentStr = indentStr;
        this.out = new OutputStreamWriter(new ConsumingOutputStream(this::printWithIndent));
    }

    public void pushIndent() {
        ++this.indent;
    }

    public void popIndent() {
        --this.indent;
    }

    private void printWithIndent(String s) {
        if (s.isEmpty()) {
            this.delegate.println();
            return;
        }
        for (int i = 0; i < this.indent; ++i) {
            this.delegate.print(this.indentStr);
        }
        this.delegate.println(s);
    }
}

