/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.diffpatch.util;

import io.codechicken.diffpatch.util.archiver.ArchiveFormat;
import io.codechicken.diffpatch.util.archiver.ArchiveWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.WillClose;

public class ArchiveBuilder {
    private final Map<String, byte[]> entries = new LinkedHashMap<String, byte[]>();

    public Set<String> getEntries() {
        return this.entries.keySet();
    }

    public byte[] getBytes(String entry) {
        return this.entries.get(entry);
    }

    public ArchiveBuilder put(String name, byte[] data) {
        this.entries.put(name, data);
        return this;
    }

    public byte[] toBytes(ArchiveFormat format) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.write(format, bos);
        return bos.toByteArray();
    }

    public void write(ArchiveFormat format, @WillClose OutputStream os) throws IOException {
        try (ArchiveWriter writer = format.createWriter(os);){
            for (Map.Entry<String, byte[]> entry : this.entries.entrySet()) {
                writer.writeEntry(entry.getKey(), entry.getValue());
            }
        }
    }
}

