/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.mcmaven.impl.GlobalOptions;
import net.minecraftforge.mcmaven.impl.mappings.Mappings;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.tasks.MCPNames;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.util.file.FileUtils;
import net.minecraftforge.util.hash.HashFunction;
import net.minecraftforge.util.hash.HashStore;
import net.minecraftforge.util.hash.HashUtils;
import org.apache.commons.io.IOUtils;

public final class RenameTask
implements Supplier<Task> {
    private final Artifact name;
    private final MCPSide side;
    private final Task task;

    public RenameTask(File build, Artifact name, MCPSide side, Task sources, Mappings mappings) {
        this.name = name;
        this.side = side;
        this.task = this.remapSources(sources, mappings.getFolder(build), mappings);
    }

    @Override
    public Task get() {
        return this.task;
    }

    private Task remapSources(Task input, File outputDir, Mappings provider) {
        File output = new File(outputDir, "remapped.jar");
        Task mappings = provider.getCsvZip(this.side);
        return Task.named("remap[" + this.name.getName() + "][" + String.valueOf(provider) + "]", Set.of(input, mappings), () -> RenameTask.remapSourcesImpl(input, mappings, output));
    }

    private static File remapSourcesImpl(Task inputTask, Task mappingsTask, File output) {
        File input = inputTask.execute();
        File mappings = mappingsTask.execute();
        HashStore cache = HashStore.fromFile(output);
        cache.add("input", input);
        cache.add("mappings", mappings);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        GlobalOptions.assertNotCacheOnly();
        try {
            MCPNames names = MCPNames.load(mappings);
            names.rename(new FileInputStream(input), true);
            FileUtils.ensureParent(output);
            try (ZipInputStream zin = new ZipInputStream(new FileInputStream(input));
                 ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(output));){
                ZipEntry entry = zin.getNextEntry();
                while (entry != null) {
                    zout.putNextEntry(FileUtils.getStableEntry(entry.getName()));
                    if (entry.getName().endsWith(".java")) {
                        String mapped = names.rename(zin, false);
                        IOUtils.write(mapped, (OutputStream)zout, StandardCharsets.UTF_8);
                    } else {
                        IOUtils.copy((InputStream)zin, (OutputStream)zout);
                    }
                    entry = zin.getNextEntry();
                }
            }
            HashUtils.updateHash(output, HashFunction.SHA1);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to rename sources for " + input.getAbsolutePath(), e);
        }
        cache.save();
        return output;
    }
}

