/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.java_provisioner;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.java_provisioner.Disco;
import net.minecraftforge.java_provisioner.JavaHomeLocator;
import net.minecraftforge.java_provisioner.api.IJavaInstall;
import net.minecraftforge.java_provisioner.util.OS;

public class JavaDirectoryLocator
extends JavaHomeLocator {
    private final Collection<File> paths;

    private static Collection<File> guesses() {
        ArrayList<File> ret = new ArrayList<File>();
        if (OS.CURRENT == OS.WINDOWS) {
            File[] roots = File.listRoots();
            for (int i = 0; i < roots.length; ++i) {
                ret.add(new File(roots[i], "Program Files\\Java"));
                if (!Disco.Arch.CURRENT.is64Bit()) continue;
                ret.add(new File(roots[i], "Program Files (x86)\\Java"));
            }
        } else if (OS.CURRENT == OS.OSX) {
            ret.add(new File("/Library/Java/JavaVirtualMachines"));
        } else {
            ret.add(new File("/usr/java"));
            ret.add(new File("/usr/lib/jvm"));
            ret.add(new File("/usr/lib64/jvm"));
            ret.add(new File("/usr/local/"));
            ret.add(new File("/opt"));
            ret.add(new File("/app/jdk"));
            ret.add(new File("/opt/jdk"));
            ret.add(new File("/opt/jdks"));
        }
        ret.removeIf(f -> !f.exists() || !f.isDirectory());
        return ret;
    }

    public JavaDirectoryLocator() {
        this(JavaDirectoryLocator.guesses());
    }

    public JavaDirectoryLocator(Collection<File> paths) {
        this.paths = this.expand(paths);
    }

    private Collection<File> expand(Collection<File> files) {
        ArrayList<File> ret = new ArrayList<File>();
        String exe = "bin/java" + OS.CURRENT.exe();
        for (File file : files) {
            if (new File(file, exe).exists()) {
                ret.add(file);
                continue;
            }
            File[] subFiles = file.listFiles();
            if (subFiles == null) continue;
            for (File subFile : subFiles) {
                if (!subFile.isDirectory() || !new File(subFile, exe).exists()) continue;
                ret.add(subFile);
            }
        }
        return ret;
    }

    @Override
    public File find(int version) {
        for (File path : this.paths) {
            IJavaInstall result = this.fromPath(path);
            if (result == null || result.majorVersion() != version) continue;
            return result.home();
        }
        return null;
    }

    @Override
    public List<IJavaInstall> findAll() {
        ArrayList<IJavaInstall> ret = new ArrayList<IJavaInstall>();
        for (File path : this.paths) {
            IJavaInstall result = this.fromPath(path);
            if (result == null) continue;
            ret.add(result);
        }
        return ret;
    }
}

