/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.mappings;

import de.siegmar.fastcsv.writer.CsvWriter;
import de.siegmar.fastcsv.writer.LineDelimiter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.mcmaven.impl.cache.Cache;
import net.minecraftforge.mcmaven.impl.cache.MavenCache;
import net.minecraftforge.mcmaven.impl.mappings.Mappings;
import net.minecraftforge.mcmaven.impl.mappings.ParchmentData;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCP;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MinecraftTasks;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.util.file.FileUtils;
import net.minecraftforge.util.hash.HashStore;

public class ParchmentMappings
extends Mappings {
    private Task downloadTask;

    public ParchmentMappings(String version) {
        super("parchment", Objects.requireNonNull(version, "Parchment mappings version must be present"));
        if (version.contains("-SNAPSHOT")) {
            throw new IllegalArgumentException("Parchment snapshots are not supported: " + version);
        }
    }

    @Override
    public boolean isPrimary() {
        return false;
    }

    @Override
    public Mappings withMCVersion(String mcVer) {
        if (this.version().indexOf(45) != -1) {
            return this;
        }
        return new ParchmentMappings(mcVer + "-" + this.version());
    }

    @Override
    public Task getCsvZip(MCPSide side) {
        Task ret = (Task)this.tasks.get(side);
        if (ret != null) {
            return ret;
        }
        MinecraftTasks mc = side.getMCP().getMinecraftTasks();
        Task srg = side.getTasks().getMappings();
        Task client = mc.versionFile("client_mappings", "txt");
        Task server = mc.versionFile("server_mappings", "txt");
        Task data = this.downloadTask(side.getMCP());
        ret = Task.named("srg2names[" + String.valueOf(this) + "]", Task.deps(Set.of(srg, client, server, data).stream().filter(Objects::nonNull).toList()), () -> this.getMappings(side.getMCP(), srg, client, server, data));
        this.tasks.put(side, ret);
        return ret;
    }

    private Task downloadTask(MCP mcp) {
        if (this.downloadTask == null) {
            this.downloadTask = Task.named("download[" + this.version() + "][parchment]", () -> this.download(mcp.getCache()));
        }
        return this.downloadTask;
    }

    private File download(Cache cache) {
        MavenCache maven = new MavenCache("parchment", "https://maven.parchmentmc.org/", cache.root());
        int idx = this.version().indexOf(45);
        if (idx == -1) {
            throw new IllegalStateException("Unknown Parchment version: " + this.version());
        }
        String mcversion = this.version().substring(0, idx);
        String ver = this.version().substring(idx + 1);
        Artifact artifact = Artifact.from("org.parchmentmc.data", "parchment-" + mcversion, ver, "checked").withExtension("zip");
        return maven.download(artifact);
    }

    private File getMappings(MCP mcp, Task srgTask, Task clientTask, Task serverTask, Task dataTask) throws IOException {
        File srg = srgTask.execute();
        File client = clientTask.execute();
        File server = serverTask.execute();
        File data = dataTask.execute();
        File root = this.getFolder(new File(mcp.getBuildFolder(), "data/mapings"));
        File output = new File(root, "parchment" + this.version() + ".zip");
        HashStore cache = HashStore.fromFile(output).add("srg", srg).add("client", client).add("server", server).add("data", data);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        ParchmentData json = null;
        try (ZipFile zip = new ZipFile(data);){
            ZipEntry entry = zip.getEntry("parchment.json");
            if (entry == null) {
                throw new IllegalStateException("Invalid parchment data archive, missing parchment.json: " + data.getAbsolutePath());
            }
            json = ParchmentData.load(zip.getInputStream(entry));
            json.bake();
        }
        catch (IOException e) {
            Util.sneak(e);
        }
        IMappingFile obf2mojClient = IMappingFile.load(client).reverse();
        IMappingFile obf2mojServer = IMappingFile.load(server).reverse();
        IMappingFile obf2srg = IMappingFile.load(srg);
        SideData clientData = ParchmentMappings.gather(obf2srg, obf2mojClient, json, true);
        SideData serverData = ParchmentMappings.gather(obf2srg, obf2mojServer, json, false);
        record Type(String file, Function<SideData, Map<String, Info>> data) {
        }
        Type[] types = new Type[]{new Type("packages.csv", SideData::packages), new Type("classes.csv", SideData::classes), new Type("fields.csv", SideData::fields), new Type("methods.csv", SideData::methods), new Type("params.csv", SideData::params)};
        FileUtils.ensureParent(output);
        try (FileOutputStream fos = new FileOutputStream(output);
             ZipOutputStream out = new ZipOutputStream(fos);){
            OutputStreamWriter uncloseable = new OutputStreamWriter(this, out, StandardCharsets.UTF_8){

                @Override
                public void close() throws IOException {
                    this.flush();
                }
            };
            for (Type type : types) {
                List<String[]> entries = ParchmentMappings.getEntries(type.file, type.data.apply(clientData), type.data.apply(serverData));
                if (entries.size() <= 1) continue;
                out.putNextEntry(Util.getStableEntry(type.file));
                try (CsvWriter writer = CsvWriter.builder().lineDelimiter(LineDelimiter.LF).build(uncloseable);){
                    for (String[] row : entries) {
                        writer.writeRecord(row);
                    }
                }
                out.closeEntry();
            }
        }
        cache.save();
        return output;
    }

    private static List<String[]> getEntries(String file, Map<String, Info> cData, Map<String, Info> sData) {
        String[] header = new String[]{"searge", "name", "side", "desc"};
        if ("params.csv".equals(file)) {
            header[0] = "param";
        }
        ArrayList<String[]> ret = new ArrayList<String[]>();
        ret.add(header);
        for (String string : cData.keySet()) {
            Info s;
            Info c = cData.get(string);
            if (c.equals(s = sData.get(string))) {
                ret.add(new String[]{string, c.name, "2", c.desc});
                sData.remove(string);
                continue;
            }
            ret.add(new String[]{string, c.name, "2", c.desc});
        }
        for (Map.Entry entry : sData.entrySet()) {
            Info value = (Info)entry.getValue();
            ret.add(new String[]{(String)entry.getKey(), value.name, "1", value.desc});
        }
        return ret;
    }

    private static SideData gather(IMappingFile obf2srg, IMappingFile obf2moj, ParchmentData parchment, boolean limited) {
        SideData ret = new SideData();
        if (parchment.packages != null) {
            for (ParchmentData.Package package_ : parchment.packages) {
                String name = package_.name + "/";
                boolean found = false;
                for (IMappingFile.IClass iClass : obf2moj.getClasses()) {
                    if (!iClass.getMapped().startsWith(name)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                ret.packages.put(package_.name, new Info(package_.name, ParchmentMappings.getJavadocs(package_.javadoc)));
            }
        }
        for (IMappingFile.IClass iClass : obf2moj.getClasses()) {
            IMappingFile.IClass srgCls = obf2srg.getClass(iClass.getOriginal());
            ParchmentData.Clazz parchCls = parchment.classMap.get(iClass.getMapped());
            String srgClsName = srgCls == null ? iClass.getMapped() : srgCls.getMapped();
            ParchmentMappings.add(ret.classes, srgClsName, iClass.getMapped(), parchCls);
            for (IMappingFile.IField iField : iClass.getFields()) {
                String srgFldName;
                IMappingFile.IField srgFld = srgCls == null ? null : srgCls.getField(iField.getOriginal());
                ParchmentData.Field parchFld = parchCls == null ? null : parchCls.fieldMap.get(iField.getMapped());
                String string = srgFldName = srgFld == null ? iField.getMapped() : srgFld.getMapped();
                if (!srgFldName.startsWith("field_") && !srgFldName.startsWith("f_")) continue;
                ParchmentMappings.add(ret.fields, srgFldName, iField.getMapped(), parchFld);
            }
            for (IMappingFile.IMethod iMethod : iClass.getMethods()) {
                String srgMtdName;
                IMappingFile.IMethod srgMtd = srgCls == null ? null : srgCls.getMethod(iMethod.getOriginal(), iMethod.getDescriptor());
                ParchmentData.Method parchMtd = parchCls == null ? null : parchCls.methodMap.get(iMethod.getMapped() + iMethod.getMappedDescriptor());
                String string = srgMtdName = srgMtd == null ? iMethod.getMapped() : srgMtd.getMapped();
                if (srgMtdName.startsWith("func_") || srgMtdName.startsWith("m_")) {
                    ParchmentMappings.add(ret.methods, srgMtdName, iMethod.getMapped(), parchMtd);
                }
                if (srgMtd == null || srgMtd.getParameters().isEmpty() || parchMtd == null) continue;
                boolean isStatic = srgMtd.getMetadata().containsKey("is_static");
                List<String> types = ParchmentMappings.getParameters(iMethod.getDescriptor());
                for (IMappingFile.IParameter iParameter : srgMtd.getParameters()) {
                    int jvmIndex = isStatic ? 0 : 1;
                    int idx = 0;
                    while (idx < iParameter.getIndex()) {
                        String type;
                        if ((type = types.get(idx++)).equals("J") || type.equals("D")) {
                            jvmIndex += 2;
                            continue;
                        }
                        ++jvmIndex;
                    }
                    ParchmentData.Element parchParam = parchMtd.paramMap.get(jvmIndex);
                    if (parchParam == null || !iParameter.getMapped().startsWith("p_")) continue;
                    ParchmentMappings.add(ret.params, iParameter.getMapped(), parchParam.name, parchParam);
                }
            }
        }
        return ret;
    }

    private static void add(Map<String, Info> map, String orig, String mapped, ParchmentData.Element element) {
        String desc;
        String string = desc = element == null ? null : ParchmentMappings.getJavadocs(element.javadoc);
        if (!orig.equals(mapped) || desc != null) {
            map.put(orig, new Info(mapped, desc));
        }
    }

    private static String getJavadocs(List<String> javadoc) {
        if (javadoc == null || javadoc.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int x = 0;
        for (String line : javadoc) {
            sb.append(line);
            if (x++ == javadoc.size() - 1) continue;
            sb.append("\\n");
        }
        return sb.toString();
    }

    private static List<String> getParameters(String desc) {
        ArrayList<String> ret = new ArrayList<String>();
        int idx = 1;
        while (desc.charAt(idx) != ')') {
            int end;
            int current = idx;
            while (desc.charAt(idx) == '[') {
                ++idx;
            }
            if (desc.charAt(idx++) == 'L' && (end = desc.indexOf(59, idx)) != -1) {
                idx = end;
            }
            ret.add(desc.substring(current, idx));
        }
        return ret;
    }

    private record SideData(Map<String, Info> packages, Map<String, Info> classes, Map<String, Info> fields, Map<String, Info> methods, Map<String, Info> params) {
        SideData() {
            this(new TreeMap<String, Info>(), new TreeMap<String, Info>(), new TreeMap<String, Info>(), new TreeMap<String, Info>(), new TreeMap<String, Info>());
        }
    }

    private record Info(String name, String desc) {
    }
}

