/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.cache;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraftforge.java_provisioner.api.IJavaInstall;
import net.minecraftforge.java_provisioner.api.IJavaLocator;
import net.minecraftforge.mcmaven.impl.GlobalOptions;
import net.minecraftforge.util.logging.Log;
import org.jetbrains.annotations.Nullable;

public final class JDKCache {
    private boolean attemptedLocate = false;
    private final File root;
    private final Map<Integer, File> jdks = new HashMap<Integer, File>();
    private final IJavaLocator disco;

    public JDKCache(File cache) {
        this.root = cache;
        this.disco = IJavaLocator.disco(cache, GlobalOptions.isOffline());
    }

    public File root() {
        return this.root;
    }

    @Nullable
    public File get(int version) {
        File ret;
        if (!this.attemptedLocate) {
            this.attemptLocate();
        }
        if ((ret = this.jdks.get(version)) != null) {
            return ret;
        }
        try {
            IJavaInstall downloaded = this.disco.provision(version);
            if (downloaded == null) {
                return null;
            }
            ret = downloaded.home();
        }
        catch (Exception e) {
            return null;
        }
        File old = this.jdks.putIfAbsent(version, ret);
        if (old != null) {
            Log.error("JDKCache: Downloaded JDK " + version + " is replacing an existing download! It was probably downloaded by another thread.");
            Log.error("JDKCache: Old JDK: " + String.valueOf(old));
        }
        return ret;
    }

    private void attemptLocate() {
        if (this.attemptedLocate) {
            return;
        }
        this.attemptedLocate = true;
        ArrayList<IJavaLocator> locators = new ArrayList<IJavaLocator>();
        locators.add(IJavaLocator.home());
        locators.add(IJavaLocator.gradle());
        locators.add(this.disco);
        ArrayList<IJavaInstall> installs = new ArrayList<IJavaInstall>();
        for (IJavaLocator locator : locators) {
            List<IJavaInstall> found = locator.findAll();
            installs.addAll(found);
        }
        HashSet seen = new HashSet();
        installs.removeIf(install -> !seen.add(install.home()));
        Collections.sort(installs);
        for (IJavaInstall install2 : installs) {
            if (!install2.isJdk() || install2.majorVersion() <= 0) continue;
            this.jdks.putIfAbsent(install2.majorVersion(), install2.home());
        }
    }
}

