/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.diffpatch.match;

import it.unimi.dsi.fastutil.ints.AbstractInt2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PatienceMatch {
    private String chars1;
    private String chars2;
    private int[] unique1;
    private int[] unique2;
    private int[] matches;
    private final IntList subChars = new IntArrayList();

    private void match(int start1, int end1, int start2, int end2) {
        while (start1 < end1 && start2 < end2 && this.chars1.charAt(start1) == this.chars2.charAt(start2)) {
            this.matches[start1++] = start2++;
        }
        while (start1 < end1 && start2 < end2 && this.chars1.charAt(end1 - 1) == this.chars2.charAt(end2 - 1)) {
            this.matches[--end1] = --end2;
        }
        if (start1 == end1 || start2 == end2 || end1 - start1 + end2 - start2 <= 3) {
            return;
        }
        boolean any = false;
        for (Int2IntMap.Entry entry : this.lcsUnique(start1, end1, start2, end2)) {
            int m2;
            int m1 = entry.getIntKey();
            this.matches[m1] = m2 = entry.getIntValue();
            any = true;
            this.match(start1, m1, start2, m2);
            start1 = m1 + 1;
            start2 = m2 + 1;
        }
        if (any) {
            this.match(start1, end1, start2, end2);
        }
    }

    private int[] match() {
        this.matches = new int[this.chars1.length()];
        for (int i = 0; i < this.chars1.length(); ++i) {
            this.matches[i] = -1;
        }
        this.match(0, this.chars1.length(), 0, this.chars2.length());
        return this.matches;
    }

    public int[] match(String chars1, String chars2, int maxChar) {
        if (this.unique1 == null || this.unique1.length < maxChar) {
            this.unique1 = new int[maxChar];
            this.unique2 = new int[maxChar];
            for (int i = 0; i < maxChar; ++i) {
                this.unique2[i] = -1;
                this.unique1[i] = -1;
            }
        }
        this.chars1 = chars1;
        this.chars2 = chars2;
        return this.match();
    }

    private List<Int2IntMap.Entry> lcsUnique(int start1, int end1, int start2, int end2) {
        char c;
        int i;
        for (i = start1; i < end1; ++i) {
            c = this.chars1.charAt(i);
            if (this.unique1[c] == -1) {
                this.unique1[c] = i;
                this.subChars.add(c);
                continue;
            }
            this.unique1[c] = -2;
        }
        for (i = start2; i < end2; ++i) {
            c = this.chars2.charAt(i);
            if (this.unique1[c] < 0) continue;
            this.unique2[c] = this.unique2[c] == -1 ? i : -2;
        }
        IntArrayList common1 = new IntArrayList();
        IntArrayList common2 = new IntArrayList();
        IntListIterator intListIterator = this.subChars.iterator();
        while (intListIterator.hasNext()) {
            int i2 = (Integer)intListIterator.next();
            if (this.unique1[i2] >= 0 && this.unique2[i2] >= 0) {
                common1.add(this.unique1[i2]);
                common2.add(this.unique2[i2]);
            }
            this.unique2[i2] = -1;
            this.unique1[i2] = -1;
        }
        this.subChars.clear();
        if (common2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Int2IntMap.Entry> ret = new ArrayList<Int2IntMap.Entry>();
        for (int i3 : PatienceMatch.lasIndices(common2)) {
            ret.add(new AbstractInt2IntMap.BasicEntry(common1.getInt(i3), common2.getInt(i3)));
        }
        return ret;
    }

    public static int[] lasIndices(IntList sequence) {
        if (sequence.isEmpty()) {
            return new int[0];
        }
        ArrayList<LCANode> pileTops = new ArrayList<LCANode>();
        pileTops.add(new LCANode(0, null));
        for (int i = 1; i < sequence.size(); ++i) {
            int v = sequence.getInt(i);
            int a = 0;
            int b = pileTops.size();
            while (a != b) {
                int c = (a + b) / 2;
                if (sequence.getInt(((LCANode)pileTops.get((int)c)).value) > v) {
                    b = c;
                    continue;
                }
                a = c + 1;
            }
            if (a < pileTops.size()) {
                pileTops.set(a, new LCANode(i, a > 0 ? (LCANode)pileTops.get(a - 1) : null));
                continue;
            }
            pileTops.add(new LCANode(i, (LCANode)pileTops.get(a - 1)));
        }
        int[] las = new int[pileTops.size()];
        int j = pileTops.size() - 1;
        LCANode node = (LCANode)pileTops.get(j);
        while (node != null) {
            las[j--] = node.value;
            node = node.prev;
        }
        return las;
    }

    private static class LCANode {
        public final int value;
        public final LCANode prev;

        public LCANode(int value, LCANode prev) {
            this.value = value;
            this.prev = prev;
        }
    }
}

