/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.tasks;

import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.NamedCsvRecord;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.util.hash.HashFunction;
import net.minecraftforge.util.logging.Log;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class MCPNames {
    private static final Pattern SRG_FINDER = Pattern.compile("[fF]unc_\\d+_[a-zA-Z_]+|m_\\d+_|[fF]ield_\\d+_[a-zA-Z_]+|f_\\d+_|p_\\w+_\\d+_|p_\\d+_");
    private static final Pattern CONSTRUCTOR_JAVADOC_PATTERN = Pattern.compile("^(?<indent>(?: {3})+|\\t+)(public |private|protected |)(?<generic><[\\w\\W]*>\\s+)?(?<name>[\\w.]+)\\((?<parameters>.*)\\)\\s+(?:throws[\\w.,\\s]+)?\\{");
    private static final Pattern METHOD_JAVADOC_PATTERN = Pattern.compile("^(?<indent>(?: {3})+|\\t+)(?!return)(?:\\w+\\s+)*(?<generic><[\\w\\W]*>\\s+)?(?<return>\\w+[\\w$.]*(?:<[\\w\\W]*>)?[\\[\\]]*)\\s+(?<name>(?:func_|m_)[0-9]+_[a-zA-Z_]*)\\(");
    private static final Pattern FIELD_JAVADOC_PATTERN = Pattern.compile("^(?<indent>(?: {3})+|\\t+)(?!return)(?:\\w+\\s+)*\\w+[\\w$.]*(?:<[\\w\\W]*>)?[\\[\\]]*\\s+(?<name>(?:field_|f_)[0-9]+_[a-zA-Z_]*) *[=;]");
    private static final Pattern CLASS_JAVADOC_PATTERN = Pattern.compile("^(?<indent> *|\\t*)([\\w|@]*\\s)*(class|interface|@interface|enum) (?<name>[\\w]+)");
    private static final Pattern CLOSING_CURLY_BRACE = Pattern.compile("^(?<indent> *|\\t*)}");
    private static final Pattern PACKAGE_DECL = Pattern.compile("^[\\s]*package(\\s)*(?<name>[\\w|.]+);$");
    private static final Pattern LAMBDA_DECL = Pattern.compile("\\((?<args>(?:(?:, ){0,1}p_[\\w]+_\\d+_\\b)+)\\) ->");
    private static final Pattern ARGS_DELIM = Pattern.compile(", ");
    private final String hash;
    private final Map<String, String> names;
    private final Map<String, String> docs;

    static MCPNames load(File data) throws IOException {
        HashMap<String, String> names = new HashMap<String, String>();
        HashMap<String, String> docs = new HashMap<String, String>();
        try (ZipFile zip = new ZipFile(data);){
            List<ZipEntry> entries = zip.stream().filter(e -> e.getName().endsWith(".csv")).toList();
            for (ZipEntry entry : entries) {
                CsvReader<NamedCsvRecord> reader = CsvReader.builder().ofNamedCsvRecord(new InputStreamReader(zip.getInputStream(entry)));
                try {
                    for (NamedCsvRecord row : reader) {
                        String desc;
                        List<String> header = row.getHeader();
                        String obf = header.contains("searge") ? "searge" : "param";
                        String searge = row.getField(obf);
                        names.put(searge, row.getField("name"));
                        if (!header.contains("desc") || (desc = row.getField("desc")).isBlank()) continue;
                        docs.put(searge, desc);
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
        }
        return new MCPNames(HashFunction.SHA1.hash(data), names, docs);
    }

    MCPNames(String hash, Map<String, String> names, Map<String, String> docs) {
        this.hash = hash;
        this.names = names;
        this.docs = docs;
    }

    String rename(String entry) {
        return this.names.getOrDefault(entry, entry);
    }

    String rename(InputStream stream, boolean javadocs) throws IOException {
        return this.rename(stream, javadocs, true, StandardCharsets.UTF_8);
    }

    String rename(InputStream stream, boolean javadocs, boolean lambdas) throws IOException {
        return this.rename(stream, javadocs, lambdas, StandardCharsets.UTF_8);
    }

    String rename(InputStream stream, boolean javadocs, boolean lambdas, Charset sourceFileCharset) throws IOException {
        String data = IOUtils.toString(stream, sourceFileCharset);
        List<String> input = IOUtils.readLines(new StringReader(data));
        if (data.isEmpty()) {
            return "";
        }
        if (data.charAt(data.length() - 1) == '\r' || data.charAt(data.length() - 1) == '\n') {
            input.add("");
        }
        ArrayList<String> lines = new ArrayList<String>();
        LinkedList<Pair<String, Integer>> innerClasses = new LinkedList<Pair<String, Integer>>();
        Object _package = "";
        HashSet<String> blacklist = new HashSet<String>();
        if (!lambdas) {
            for (String line : input) {
                Matcher matcher = LAMBDA_DECL.matcher(line);
                if (!matcher.find()) continue;
                blacklist.addAll(Arrays.asList(ARGS_DELIM.split(matcher.group("args"))));
            }
        }
        for (String line : input) {
            Matcher m = PACKAGE_DECL.matcher(line);
            if (m.find()) {
                _package = m.group("name") + ".";
            }
            if (javadocs && !this.injectJavadoc(lines, line, (String)_package, innerClasses)) {
                javadocs = false;
            }
            lines.add(this.replaceInLine(line, blacklist));
        }
        return String.join((CharSequence)System.lineSeparator(), lines);
    }

    private boolean injectJavadoc(List<String> lines, String line, String _package, Deque<Pair<String, Integer>> innerClasses) {
        boolean isConstructor;
        Matcher matcher = CONSTRUCTOR_JAVADOC_PATTERN.matcher(line);
        boolean bl = isConstructor = matcher.find() && !innerClasses.isEmpty() && innerClasses.peek().getLeft().contains(matcher.group("name"));
        if (!isConstructor) {
            matcher = METHOD_JAVADOC_PATTERN.matcher(line);
        }
        if (isConstructor || matcher.find()) {
            String name = isConstructor ? "<init>" : matcher.group("name");
            String javadoc = this.docs.get(name);
            if (!(javadoc != null || innerClasses.isEmpty() || name.startsWith("func_") || name.startsWith("m_"))) {
                String currentClass = innerClasses.peek().getLeft();
                javadoc = this.docs.get(currentClass + "#" + name);
            }
            if (javadoc != null) {
                MCPNames.insertAboveAnnotations(lines, JavadocAdder.buildJavadoc(matcher.group("indent"), javadoc, true));
            }
            return true;
        }
        matcher = FIELD_JAVADOC_PATTERN.matcher(line);
        if (matcher.find()) {
            String name = matcher.group("name");
            String javadoc = this.docs.get(name);
            if (!(javadoc != null || innerClasses.isEmpty() || name.startsWith("field_") || name.startsWith("f_"))) {
                String currentClass = innerClasses.peek().getLeft();
                javadoc = this.docs.get(currentClass + "#" + name);
            }
            if (javadoc != null) {
                MCPNames.insertAboveAnnotations(lines, JavadocAdder.buildJavadoc(matcher.group("indent"), javadoc, false));
            }
            return true;
        }
        matcher = CLASS_JAVADOC_PATTERN.matcher(line);
        if (matcher.find()) {
            String currentClass = (String)(innerClasses.isEmpty() ? _package : innerClasses.peek().getLeft() + "$") + matcher.group("name");
            innerClasses.push(Pair.of(currentClass, matcher.group("indent").length()));
            String javadoc = this.docs.get(currentClass);
            if (javadoc != null) {
                MCPNames.insertAboveAnnotations(lines, JavadocAdder.buildJavadoc(matcher.group("indent"), javadoc, true));
            }
            return true;
        }
        matcher = CLOSING_CURLY_BRACE.matcher(line);
        if (matcher.find() && !innerClasses.isEmpty()) {
            int len = matcher.group("indent").length();
            if (len == innerClasses.peek().getRight()) {
                innerClasses.pop();
            } else if (len < innerClasses.peek().getRight()) {
                Log.error("Failed to properly track class blocks around class " + innerClasses.peek().getLeft() + ":" + (lines.size() + 1));
                return false;
            }
        }
        return true;
    }

    private static void insertAboveAnnotations(List<String> list, String line) {
        int back = 0;
        while (list.get(list.size() - 1 - back).trim().startsWith("@")) {
            ++back;
        }
        list.add(list.size() - back, line);
    }

    private String getMapped(String srg, @Nullable Set<String> blacklist) {
        boolean cap;
        if (blacklist != null && blacklist.contains(srg)) {
            return srg;
        }
        boolean bl = cap = ((String)srg).charAt(0) == 'F';
        if (cap) {
            srg = "f" + ((String)srg).substring(1);
        }
        Object ret = this.names.getOrDefault(srg, (String)srg);
        if (cap) {
            ret = ((String)ret).substring(0, 1).toUpperCase(Locale.ENGLISH) + ((String)ret).substring(1);
        }
        return ret;
    }

    private String replaceInLine(String line, @Nullable Set<String> blacklist) {
        StringBuffer buf = new StringBuffer();
        Matcher matcher = SRG_FINDER.matcher(line);
        while (matcher.find()) {
            matcher.appendReplacement(buf, Matcher.quoteReplacement(this.getMapped(matcher.group(), blacklist)));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    private static interface JavadocAdder {
        public static String buildJavadoc(String indent, String javadoc, boolean multiline) {
            StringBuilder builder = new StringBuilder();
            LinkedList<String> list = new LinkedList<String>();
            for (String line : javadoc.split("\n")) {
                list.addAll(JavadocAdder.wrapText(line, 120 - (indent.length() + 3)));
            }
            if (list.size() > 1 || multiline) {
                builder.append(indent);
                builder.append("/**");
                builder.append(System.lineSeparator());
                for (String line : list) {
                    builder.append(indent);
                    builder.append(" * ");
                    builder.append(line);
                    builder.append(System.lineSeparator());
                }
                builder.append(indent);
                builder.append(" */");
            } else {
                builder.append(indent);
                builder.append("/** ");
                builder.append(javadoc);
                builder.append(" */");
            }
            return builder.toString().replace(indent, indent);
        }

        private static @Unmodifiable Collection<String> wrapText(String text, int len) {
            if (text == null) {
                return List.of();
            }
            if (len <= 0 || text.length() <= len) {
                return List.of(text);
            }
            LinkedList<String> lines = new LinkedList<String>();
            StringBuilder line = new StringBuilder();
            StringBuilder word = new StringBuilder();
            block3: for (char c : text.toCharArray()) {
                switch (c) {
                    case ' ': 
                    case ',': 
                    case '-': {
                        int tempNum;
                        word.append(c);
                        int n = tempNum = Character.isWhitespace(c) ? 1 : 0;
                        if (line.length() + word.length() - tempNum > len) {
                            lines.add(line.toString());
                            line.delete(0, line.length());
                        }
                        line.append((CharSequence)word);
                        word.delete(0, word.length());
                        continue block3;
                    }
                    default: {
                        word.append(c);
                    }
                }
            }
            if (!word.isEmpty()) {
                if (line.length() + word.length() > len) {
                    lines.add(line.toString());
                    line.delete(0, line.length());
                }
                line.append((CharSequence)word);
            }
            if (!line.isEmpty()) {
                lines.add(line.toString());
            }
            return lines.stream().map(String::trim).toList();
        }
    }
}

