/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.util;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.util.logging.Log;

public sealed interface Task
extends Supplier<File> {
    public static Task existing(String name, File file) {
        return new Existing(name, file);
    }

    public static Task named(String name, Callable<File> supplier) {
        return Task.named(name, Set.of(), supplier);
    }

    public static Task named(String name, Iterable<? extends Task> deps, Callable<File> supplier) {
        return new Simple(name, deps, supplier);
    }

    public static Iterable<? extends Task> collect(final Object ... deps) {
        return () -> new Iterator<Task>(){
            private final Iterator<?> itor;
            {
                this.itor = Arrays.asList(deps).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itor.hasNext();
            }

            @Override
            public Task next() {
                Object obj = this.itor.next();
                if (!(obj instanceof Task) && obj instanceof Supplier) {
                    Supplier supplier = (Supplier)obj;
                    obj = supplier.get();
                }
                try {
                    return (Task)obj;
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Invalid task dependency. Expected Task or Supplier<Task>, Found: %s".formatted(obj), e);
                }
            }
        };
    }

    public File execute();

    public boolean resolved();

    public String name();

    @Override
    default public File get() {
        return this.execute();
    }

    public record Existing(String name, File execute) implements Task
    {
        @Override
        public boolean resolved() {
            return true;
        }

        @Override
        public String toString() {
            return "Task[" + this.name + "]";
        }
    }

    public static final class Simple
    implements Task {
        private final String name;
        private final Iterable<? extends Task> deps;
        private final Callable<File> supplier;
        private File file;

        private Simple(String name, Iterable<? extends Task> deps, Callable<File> supplier) {
            this.name = name;
            this.deps = deps;
            this.supplier = supplier;
        }

        @Override
        public File execute() {
            if (this.file == null) {
                for (Task task : this.deps) {
                    task.execute();
                }
                Log.info(this.name);
                Log.push();
                try {
                    this.file = this.supplier.call();
                }
                catch (Exception e) {
                    Util.sneak(e);
                }
                Log.debug("-> " + this.file.getAbsolutePath());
                Log.pop();
            }
            return this.file;
        }

        @Override
        public boolean resolved() {
            return this.file != null;
        }

        @Override
        public String name() {
            return this.name;
        }

        public String toString() {
            return "Task[" + this.name + "]";
        }
    }
}

