/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.repo.mcpconfig;

import com.google.gson.reflect.TypeToken;
import io.codechicken.diffpatch.cli.CliOperation;
import io.codechicken.diffpatch.cli.PatchOperation;
import io.codechicken.diffpatch.util.Input;
import io.codechicken.diffpatch.util.LogLevel;
import io.codechicken.diffpatch.util.Output;
import io.codechicken.diffpatch.util.PatchMode;
import io.codechicken.diffpatch.util.archiver.ArchiveFormat;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.mcmaven.impl.GlobalOptions;
import net.minecraftforge.mcmaven.impl.cache.JDKCache;
import net.minecraftforge.mcmaven.impl.cache.MavenCache;
import net.minecraftforge.mcmaven.impl.cache.MinecraftMavenCache;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MCPSide;
import net.minecraftforge.mcmaven.impl.repo.mcpconfig.MinecraftTasks;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.ProcessUtils;
import net.minecraftforge.mcmaven.impl.util.Task;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.util.data.OS;
import net.minecraftforge.util.data.json.JsonData;
import net.minecraftforge.util.data.json.MCPConfig;
import net.minecraftforge.util.data.json.MinecraftVersion;
import net.minecraftforge.util.file.FileUtils;
import net.minecraftforge.util.hash.HashStore;
import net.minecraftforge.util.logging.Log;
import org.jetbrains.annotations.Nullable;

public class MCPTaskFactory {
    private final MCPConfig.V2 cfg;
    private final MCPSide side;
    private final File build;
    @Nullable
    private final MCPTaskFactory parent;
    private final List<Map<String, String>> steps;
    private final Map<String, Task> data = new HashMap<String, Task>();
    private final Map<String, Task> tasks = new LinkedHashMap<String, Task>();
    private final Task preStrip;
    private final Task rawJar;
    private final Task mappings;
    private final Task srgJar;
    private final Task preDecomp;
    private final Task last;
    private final BiPredicate<File, String> injectFileFilter;
    @Nullable
    private List<Lib> libraries = null;
    private static final BiPredicate<File, String> TRUE = (f, s) -> true;
    private static final BiPredicate<File, String> NOT_CONTAINS_CLIENT = (f, s) -> !s.contains("client");

    private MCPTaskFactory(MCPTaskFactory parent, File build, Task preDecomp) {
        this.parent = parent;
        this.build = build;
        this.side = parent.side;
        this.cfg = parent.cfg;
        this.steps = parent.steps;
        this.preStrip = parent.preStrip;
        this.rawJar = parent.rawJar;
        this.mappings = parent.mappings;
        this.srgJar = parent.srgJar;
        this.preDecomp = preDecomp;
        boolean foundDecomp = false;
        Task last = null;
        for (Map<String, String> step : this.steps) {
            Task task;
            String type;
            String name = step.getOrDefault("name", type = step.get("type"));
            if ("decompile".equals(name)) {
                foundDecomp = true;
                String inputTask = step.get("input");
                inputTask = inputTask.substring(1, inputTask.length() - 7);
                this.tasks.replace(inputTask, preDecomp);
                task = this.createTask(step);
                this.tasks.put(name, task);
            } else if (!foundDecomp) {
                task = this.parent.findStep(name);
                this.tasks.put(name, task);
            } else {
                task = this.createTask(step);
                this.tasks.put(name, task);
            }
            last = task;
        }
        this.last = last;
        this.injectFileFilter = this.getFileFilter();
    }

    public MCPTaskFactory(MCPSide side, File build) {
        this.parent = null;
        this.side = side;
        this.build = build;
        this.cfg = this.side.getMCP().getConfig();
        Map<String, String> entries = this.cfg.getData(this.side.getName());
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.data.put(key, Task.named("extract[" + key + "]", () -> this.extract(key, value)));
        }
        this.steps = this.cfg.getSteps(this.side.getName());
        if (this.steps.isEmpty()) {
            throw this.except("Does not contain requested side `" + side.getName() + "`");
        }
        Task prestrip = null;
        Task rawJar = null;
        Task mappings = null;
        Task srgJar = null;
        Task predecomp = null;
        Task last = null;
        for (Map<String, String> step : this.steps) {
            String type = step.get("type");
            String name = step.getOrDefault("name", type);
            Task task = this.createTask(step);
            this.tasks.put(name, task);
            last = task;
            switch (name) {
                case "strip": 
                case "stripClient": {
                    prestrip = this.findStep(step.get("input"));
                }
                case "merge": {
                    rawJar = this.findStep(name);
                    break;
                }
                case "decompile": {
                    predecomp = this.findStep(step.get("input"));
                    break;
                }
                case "rename": {
                    srgJar = this.findStep(name);
                    String value = step.getOrDefault("mappings", "{mappings}");
                    if (!value.startsWith("{") || !value.endsWith("}")) {
                        throw this.except("Expected `rename` step's `mappings` argument to be a variable");
                    }
                    mappings = value.endsWith("Output}") ? this.findStep(value) : this.findData(value);
                }
            }
        }
        if (prestrip == null) {
            throw this.except("Could not find `strip%s` step".formatted("joined".equals(side.getName()) ? "Client" : ""));
        }
        if (rawJar == null) {
            throw this.except("Could not find `%s` task".formatted("joined".equals(side.getName()) ? "merge" : "strip"));
        }
        if (mappings == null) {
            throw this.except("Could not find `mappings` task");
        }
        if (srgJar == null) {
            throw this.except("Could not find `rename` task");
        }
        if (predecomp == null) {
            throw this.except("Could not find `decompile` step");
        }
        if (last == null) {
            throw this.except("No steps defined");
        }
        this.preStrip = prestrip;
        this.rawJar = rawJar;
        this.mappings = mappings;
        this.srgJar = srgJar;
        this.preDecomp = predecomp;
        this.last = last;
        this.injectFileFilter = this.getFileFilter();
    }

    private BiPredicate<File, String> getFileFilter() {
        return this.side.containsClient() ? TRUE : NOT_CONTAINS_CLIENT;
    }

    public MCPTaskFactory child(File dir, Task predecomp) {
        return new MCPTaskFactory(this, dir, predecomp);
    }

    public Task getRawJar() {
        return this.rawJar;
    }

    public Task getMappings() {
        return this.mappings;
    }

    public Task getSrgJar() {
        return this.srgJar;
    }

    public Task getPreDecompile() {
        return this.preDecomp;
    }

    public Task getLastTask() {
        return this.last;
    }

    private RuntimeException except(String message) {
        return new IllegalArgumentException("Invalid MCP Dependency: " + String.valueOf(this.side.getMCP().getName()) + " - " + message);
    }

    private File getData() {
        return this.side.getMCP().getData();
    }

    private Task findStep(String name) {
        Task ret;
        if (name.startsWith("{") && name.endsWith("Output}")) {
            name = name.substring(1, name.length() - 7);
        }
        if ((ret = this.tasks.get(name)) == null) {
            throw this.except("Unknown task `" + name + "`");
        }
        return ret;
    }

    public Task findData(String name) {
        Task ret;
        if (this.parent != null) {
            return this.parent.findData(name);
        }
        if (name.startsWith("{") && name.endsWith("}")) {
            name = name.substring(1, name.length() - 1);
        }
        if ((ret = this.data.get(name)) == null) {
            throw this.except("Unknown data entry `" + name + "`");
        }
        return ret;
    }

    private File extract(String key, String value) {
        if (value.endsWith("/")) {
            return this.extractFolder(key, value);
        }
        return this.extractSingle(key, value);
    }

    private File extractSingle(String key, String value) {
        File file;
        int idx = value.lastIndexOf(47);
        String filename = idx == -1 ? value : value.substring(idx);
        File target = new File(this.build, "data/" + key + "/" + filename);
        HashStore cache = HashStore.fromFile(target);
        cache.add("mcp", this.getData());
        if (target.exists() && cache.isSame()) {
            return target;
        }
        GlobalOptions.assertNotCacheOnly();
        ZipFile zip = new ZipFile(this.getData());
        try {
            ZipEntry entry = zip.getEntry(value);
            if (entry == null) {
                throw this.except("Missing data: `" + key + "`: `" + value + "`");
            }
            FileUtils.ensureParent(target);
            try (FileOutputStream os = new FileOutputStream(target);){
                zip.getInputStream(entry).transferTo(os);
            }
            target.setLastModified(entry.getLastModifiedTime().toMillis());
            cache.save();
            file = target;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw this.except("Failed to extract `" + key + "`: `" + value + "`");
            }
        }
        zip.close();
        return file;
    }

    private File extractFolder(String key, String value) {
        File file;
        File base = new File(this.build, "data/" + key);
        HashStore cache = new HashStore(base).load(new File(this.build, "data/" + key + ".cache"));
        cache.add("mcp", this.getData());
        boolean same = cache.isSame();
        HashSet<File> existing = new HashSet<File>(FileUtils.listFiles(base));
        ZipFile zip = new ZipFile(this.getData());
        try {
            int count = 0;
            Enumeration<? extends ZipEntry> itr = zip.entries();
            while (itr.hasMoreElements()) {
                ZipEntry e = itr.nextElement();
                if (e.isDirectory() || !e.getName().startsWith(value)) continue;
                ++count;
                String relative = e.getName().substring(value.length());
                File target = new File(base, relative);
                existing.remove(target);
                FileUtils.ensureParent(target);
                if (target.exists() && same) continue;
                GlobalOptions.assertNotCacheOnly();
                try (FileOutputStream os = new FileOutputStream(target);){
                    zip.getInputStream(e).transferTo(os);
                }
                target.setLastModified(e.getLastModifiedTime().toMillis());
            }
            String prefix = base.getAbsolutePath() + File.separator;
            for (File f : existing) {
                if (f.exists()) {
                    f.delete();
                }
                if (f.getParentFile().listFiles().length != 0 || !f.getAbsolutePath().startsWith(prefix)) continue;
                f.getParentFile().delete();
            }
            if (count == 0) {
                throw this.except("Missing data: `" + key + "`: `" + value + "`");
            }
            cache.save();
            file = base;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw this.except("Failed to extract `" + key + "`: `" + value + "`");
            }
        }
        zip.close();
        return file;
    }

    private Task createTask(Map<String, String> step) {
        MCPConfig.Function custom;
        String type = step.get("type");
        String name = step.getOrDefault("name", type);
        MinecraftTasks mc = this.side.getMCP().getMinecraftTasks();
        int spec = this.cfg.spec;
        switch (type) {
            case "downloadManifest": {
                return mc.launcherManifest;
            }
            case "downloadJson": {
                return mc.versionJson;
            }
            case "downloadClient": {
                return mc.versionFile("client", "jar");
            }
            case "downloadServer": {
                return mc.versionFile("server", "jar");
            }
            case "strip": {
                return this.strip(name, step);
            }
            case "inject": {
                return this.inject(name, step);
            }
            case "patch": {
                return this.patch(name, step);
            }
            case "listLibraries": {
                if (spec >= 3 && step.containsKey("bundle")) {
                    return this.listLibrariesBundle(name, step);
                }
                return this.listLibraries(name, step);
            }
        }
        if (spec >= 2) {
            switch (type) {
                case "downloadClientMappings": {
                    return mc.versionFile("client_mappings", "txt");
                }
                case "downloadServerMappings": {
                    return mc.versionFile("server_mappings", "txt");
                }
            }
        }
        if ((custom = this.cfg.getFunction(type)) == null) {
            throw this.except("Unknown step type: " + type);
        }
        return this.execute(name, step, custom);
    }

    private Task strip(String name, Map<String, String> step) {
        boolean whitelist = "whitelist".equalsIgnoreCase(step.getOrDefault("mode", "whitelist"));
        File output = new File(this.build, name + ".jar").getAbsoluteFile();
        Task input = this.findStep(step.get("input"));
        return Task.named(name, Task.collect(input, () -> this.mappings), () -> this.strip(input, whitelist, output));
    }

    private File strip(Task inputTask, boolean whitelist, File output) {
        File input = inputTask.execute();
        File mappings = this.mappings.execute();
        HashStore cache = HashStore.fromFile(output);
        cache.add("input", input);
        cache.add("mappings", mappings);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        GlobalOptions.assertNotCacheOnly();
        if (output.exists()) {
            output.delete();
        }
        FileUtils.ensureParent(output);
        try {
            IMappingFile map = IMappingFile.load(mappings);
            HashSet<CallSite> classes = new HashSet<CallSite>();
            for (IMappingFile.IClass iClass : map.getClasses()) {
                classes.add((CallSite)((Object)(iClass.getOriginal() + ".class")));
            }
            try (JarInputStream is = new JarInputStream(new FileInputStream(input));
                 JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(output));){
                JarEntry entry;
                while ((entry = is.getNextJarEntry()) != null) {
                    if (entry.isDirectory() || classes.contains(entry.getName()) != whitelist) continue;
                    jarOutputStream.putNextEntry(FileUtils.getStableEntry(entry));
                    is.transferTo(jarOutputStream);
                    jarOutputStream.closeEntry();
                }
            }
            cache.save();
            return output;
        }
        catch (IOException e) {
            return (File)Util.sneak(new IOException("Failed to split " + String.valueOf(input) + " into output " + String.valueOf(output), e));
        }
    }

    private Task inject(String name, Map<String, String> step) {
        Task input = this.findStep(step.get("input"));
        Task inject = this.findData("inject");
        File packages = new File(this.build, name + "/packages.jar").getAbsoluteFile();
        File output = new File(this.build, name + "/output.jar").getAbsoluteFile();
        return Task.named(name, Set.of(input, inject), () -> this.inject(input, inject, packages, output));
    }

    private File inject(Task inputTask, Task injectTask, File packages, File output) {
        File input = inputTask.execute();
        File inject = injectTask.execute();
        HashStore cache = HashStore.fromFile(output);
        cache.add("input", input);
        cache.add("inject", inject);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        GlobalOptions.assertNotCacheOnly();
        if (output.exists()) {
            output.delete();
        }
        FileUtils.ensureParent(output);
        File templateF = new File(input, "package-info-template.java");
        String template = null;
        try {
            if (templateF.exists()) {
                long modified = templateF.lastModified();
                template = Files.readString(templateF.toPath(), StandardCharsets.UTF_8);
                TreeSet<String> pkgs = new TreeSet<String>();
                try (Closeable zip = new ZipInputStream(new FileInputStream(input));){
                    ZipEntry entry;
                    while ((entry = ((ZipInputStream)zip).getNextEntry()) != null) {
                        String pkg;
                        String name = entry.getName();
                        if (entry.isDirectory() || !name.endsWith(".java")) continue;
                        int idx = name.indexOf(47);
                        String string = pkg = idx == -1 ? "" : name.substring(0, idx);
                        if (!pkg.startsWith("net/minecraft/") && !pkg.startsWith("com/mojang/")) continue;
                        pkgs.add(pkg);
                    }
                }
                if (!packages.exists()) {
                    packages.delete();
                }
                zip = new ZipOutputStream(new FileOutputStream(packages));
                try {
                    for (String pkg : pkgs) {
                        ((ZipOutputStream)zip).putNextEntry(FileUtils.getStableEntry(pkg + "/package-info.java", modified));
                        ((FilterOutputStream)zip).write(template.replace("{PACKAGE}", pkg.replace('/', '.')).getBytes(StandardCharsets.UTF_8));
                        ((ZipOutputStream)zip).closeEntry();
                    }
                }
                finally {
                    ((ZipOutputStream)zip).close();
                }
                FileUtils.mergeJars(output, false, this.injectFileFilter, input, inject, packages);
            } else {
                FileUtils.mergeJars(output, false, this.injectFileFilter, input, inject);
            }
            cache.save();
            return output;
        }
        catch (IOException e) {
            return (File)Util.sneak(e);
        }
    }

    private Task patch(String name, Map<String, String> step) {
        Task input = this.findStep(step.get("input"));
        Task patches = this.findData("patches");
        File output = new File(this.build, name + "/output.jar");
        File rejects = new File(this.build, name + "/rejects.jar");
        return Task.named(name, Set.of(input, patches), () -> this.patch(input, patches, output, rejects));
    }

    private File patch(Task inputTask, Task patchesTask, File output, File rejects) {
        File input = inputTask.execute();
        File patches = patchesTask.execute();
        HashStore cache = HashStore.fromFile(output);
        cache.add("input", input);
        cache.add("patches", patches);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        GlobalOptions.assertNotCacheOnly();
        PatchOperation.Builder builder = PatchOperation.builder().logTo(Log::error).baseInput(Input.MultiInput.archive(ArchiveFormat.ZIP, input.toPath())).patchesInput(Input.MultiInput.folder(patches.toPath())).patchedOutput(Output.MultiOutput.archive(ArchiveFormat.ZIP, output.toPath())).rejectsOutput(Output.MultiOutput.archive(ArchiveFormat.ZIP, rejects.toPath())).level(LogLevel.ERROR).mode(PatchMode.ACCESS);
        try {
            boolean success;
            FileUtils.ensureParent(output);
            FileUtils.ensureParent(rejects);
            CliOperation.Result<PatchOperation.PatchesSummary> result = builder.build().operate();
            boolean bl = success = result.exit == 0;
            if (!success) {
                if (result.summary != null) {
                    ((PatchOperation.PatchesSummary)result.summary).print(Log.ERROR, true);
                } else {
                    Log.error("Failed to apply patches, no summary available");
                }
                throw this.except("Failed to apply patches, Rejects saved to: " + rejects.getAbsolutePath());
            }
            cache.save();
            return output;
        }
        catch (IOException e) {
            return (File)Util.sneak(e);
        }
    }

    private Task listLibraries(String name, Map<String, String> step) {
        File output = new File(this.build, name + ".txt");
        Task json = this.findStep("downloadJson");
        return Task.named(name, Set.of(json), () -> this.listLibraries(json, output));
    }

    private File listLibraries(Task jsonTask, File output) {
        File file;
        File jsonF = jsonTask.execute();
        MinecraftVersion json = JsonData.minecraftVersion(jsonF);
        List<MinecraftVersion.Lib> libs = json.getLibs();
        File libsVarCache = new File(output.getAbsoluteFile().getParentFile(), "libraries.txt");
        HashStore cache = HashStore.fromFile(output).add(jsonF).add(libsVarCache);
        for (MinecraftVersion.Lib lib : libs) {
            cache.addKnown(lib.coord, lib.dl.sha1);
        }
        if (output.exists() && libsVarCache.exists() && cache.isSame()) {
            this.libraries = JsonData.fromJson(libsVarCache, new TypeToken<List<Lib.Cached>>(this){}).stream().map(Lib.Cached::resolve).toList();
            return output;
        }
        GlobalOptions.assertNotCacheOnly();
        cache.clear().add(jsonF);
        StringBuilder buf = new StringBuilder(20000);
        MinecraftMavenCache minecraft = this.side.getMCP().getCache().minecraft();
        ArrayList<Lib> downloadedLibs = new ArrayList<Lib>();
        for (MinecraftVersion.Lib lib : libs) {
            if (!lib.dl.url.toString().startsWith("https://libraries.minecraft.net/")) {
                throw new IllegalStateException("Unable to download library " + lib.dl.path + " as it is not on Mojang's repo and I was lazy. " + String.valueOf(lib.dl.url));
            }
            File target = minecraft.download(lib.dl);
            buf.append("-e=").append(target.getAbsolutePath()).append('\n');
            Artifact artifact = Artifact.from(lib.coord);
            if (lib.os != null && lib.os != OS.UNKNOWN) {
                artifact = artifact.withOS(lib.os);
            }
            downloadedLibs.add(new Lib(artifact, target));
            cache.add(lib.coord, target);
        }
        try {
            FileUtils.ensureParent(libsVarCache);
            JsonData.toJson(downloadedLibs.stream().map(Lib::cacheable).toList(), libsVarCache);
            cache.add(libsVarCache);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.libraries = downloadedLibs;
        FileUtils.ensureParent(output);
        FileOutputStream os = new FileOutputStream(output);
        try {
            os.write(buf.toString().getBytes(StandardCharsets.UTF_8));
            cache.save();
            file = output;
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return (File)Util.sneak(e);
            }
        }
        os.close();
        return file;
    }

    public List<Lib> getLibraries() {
        if (this.libraries == null) {
            this.findStep("listLibraries").execute();
        }
        return this.libraries;
    }

    private Task listLibrariesBundle(String name, Map<String, String> step) {
        Task bundle = this.findStep(step.get("bundle"));
        File libraries = new File(this.build, name);
        File output = new File(this.build, name + "/libraries.txt");
        return Task.named(name, Set.of(bundle), () -> this.listLibrariesBundle(bundle, libraries, output));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File listLibrariesBundle(Task bundleTask, File libraries, File output) {
        File bundle = bundleTask.execute();
        try (JarFile jar = new JarFile(bundle);){
            String line;
            String format = jar.getManifest().getMainAttributes().getValue("Bundler-Format");
            if (format == null) {
                throw new IllegalStateException("Invalid bundle: `" + String.valueOf(bundle) + "` - Missing format entry from manifest");
            }
            if (!"1.0".equals(format)) {
                throw new RuntimeException("Invalid bundle: `" + String.valueOf(bundle) + "` - Unsupported format " + format);
            }
            ZipEntry entry = jar.getEntry("META-INF/libraries.list");
            if (entry == null) {
                throw new IllegalStateException("Invalid bundle: `" + String.valueOf(bundle) + "` - Missing META-INF/libraries.list");
            }
            record LibLine(String hash, Artifact artifact, String path) implements Comparable<LibLine>
            {
                @Override
                public int compareTo(LibLine o) {
                    return Util.compare(this.artifact, o.artifact);
                }
            }
            TreeSet<LibLine> libs = new TreeSet<LibLine>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(jar.getInputStream(entry)));
            while ((line = reader.readLine()) != null) {
                String[] pts = line.split("\t");
                if (pts.length < 3) {
                    throw new IllegalStateException("Invalid bundle: `" + String.valueOf(bundle) + "` - Invalid line: " + line);
                }
                libs.add(new LibLine(pts[0], Artifact.from(pts[1]), pts[2]));
            }
            HashStore cache = HashStore.fromFile(output).add(bundle);
            for (LibLine lib : libs) {
                cache.add(lib.artifact().toString(), new File(libraries, lib.path()));
            }
            if (output.exists() && cache.isSame()) {
                File file = output;
                return file;
            }
            GlobalOptions.assertNotCacheOnly();
            cache.clear().add(bundle);
            StringBuilder buf = new StringBuilder();
            ArrayList<Lib> downloadedLibs = new ArrayList<Lib>();
            for (LibLine lib : libs) {
                File target = new File(libraries, lib.path());
                Artifact artifact = lib.artifact();
                buf.append("-e=").append(target.getAbsolutePath()).append('\n');
                downloadedLibs.add(new Lib(artifact, target));
                if (!target.exists()) {
                    entry = jar.getEntry("META-INF/libraries/" + lib.path());
                    if (entry == null) {
                        throw new IllegalStateException("Invalid bundle: `" + String.valueOf(bundle) + "` - Missing META-INF/libraries/" + String.valueOf(lib));
                    }
                    FileUtils.ensureParent(target);
                    try (FileOutputStream os = new FileOutputStream(target);
                         InputStream is = jar.getInputStream(entry);){
                        is.transferTo(os);
                    }
                }
                cache.add(target);
            }
            this.libraries = Collections.unmodifiableList(downloadedLibs);
            FileUtils.ensureParent(output);
            try (FileOutputStream os = new FileOutputStream(output);){
                os.write(buf.toString().getBytes(StandardCharsets.UTF_8));
            }
            cache.save();
            File file = output;
            return file;
        }
        catch (IOException e) {
            return (File)Util.sneak(e);
        }
    }

    public Task getExtra() {
        return Task.named("extra[" + this.side.getName() + "]", Set.of(this.preStrip, this.mappings), () -> this.getExtra(this.preStrip, this.mappings));
    }

    private File getExtra(Task prestripTask, Task mappingsTask) {
        File prestrip = prestripTask.execute();
        File mappings = mappingsTask.execute();
        File output = new File(this.build, "extra.jar");
        HashStore cache = HashStore.fromFile(output);
        cache.add("prestrip", prestrip);
        cache.add("mappings", mappings);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        GlobalOptions.assertNotCacheOnly();
        try {
            Set<String> whitelist = IMappingFile.load(mappings).getClasses().stream().map(IMappingFile.INode::getOriginal).collect(Collectors.toSet());
            FileUtils.splitJar(prestrip, whitelist, output, false, false);
        }
        catch (IOException e) {
            Util.sneak(e);
        }
        cache.save();
        return output;
    }

    private Task execute(String name, Map<String, String> step, MCPConfig.Function func) {
        HashMap<String, TaskOrArg> args = new HashMap<String, TaskOrArg>();
        HashSet<Task> deps = new HashSet<Task>();
        for (String key : step.keySet()) {
            String value = step.get(key);
            if (this.isVariable(value)) {
                Task task = value.endsWith("Output}") ? this.findStep(value) : this.findData(value);
                deps.add(task);
                args.put(key, new TaskOrArg(value, task, null));
                continue;
            }
            args.put(key, new TaskOrArg(value, null, value));
        }
        String ext = step.getOrDefault("outputExtension", "jar");
        File output = new File(this.build, name + "/" + name + "." + ext);
        File log = new File(this.build, name + "/log.txt");
        args.put("output", new TaskOrArg("output", null, output.getAbsolutePath()));
        args.put("log", new TaskOrArg("log", null, log.getAbsolutePath()));
        List<TaskOrArg> jvmArgs = this.fillArgs(func.jvmargs, args, deps);
        List<TaskOrArg> runArgs = this.fillArgs(func.args, args, deps);
        return Task.named(name, deps, () -> this.execute(jvmArgs, runArgs, func, log, output));
    }

    private File execute(List<TaskOrArg> jvmArgs, List<TaskOrArg> runArgs, MCPConfig.Function func, File log, File output) {
        MavenCache maven = new MavenCache("mcp-tools", func.repo, this.side.getMCP().getCache().root());
        Artifact toolA = Artifact.from(func.version);
        File tool = maven.download(toolA);
        HashStore cache = HashStore.fromFile(output);
        cache.add("tool", tool);
        cache.add("jvm-args", jvmArgs.stream().map(TaskOrArg::name).collect(Collectors.joining(" ")));
        cache.add("run-args", runArgs.stream().map(TaskOrArg::name).collect(Collectors.joining(" ")));
        HashMap<Task, String> tasks = new HashMap<Task, String>();
        List<String> jvm = this.resolveArgs(cache, tasks, jvmArgs);
        List<String> run = this.resolveArgs(cache, tasks, runArgs);
        if (output.exists() && cache.isSame()) {
            return output;
        }
        GlobalOptions.assertNotCacheOnly();
        int java_version = func.getJavaVersion(this.side.getMCP().getConfig());
        JDKCache jdks = this.side.getMCP().getCache().jdks();
        File jdk = jdks.get(java_version);
        if (jdk == null) {
            throw new IllegalStateException("Failed to find JDK for version " + java_version);
        }
        ProcessUtils.Result ret = ProcessUtils.runJar(jdk, log.getParentFile(), log, tool, jvm, run);
        if (ret.exitCode != 0) {
            throw new IllegalStateException("Failed to run MCP Step, See log: " + log.getAbsolutePath());
        }
        cache.save();
        return output;
    }

    private boolean isVariable(String value) {
        return value.startsWith("{") && value.endsWith("}");
    }

    private List<TaskOrArg> fillArgs(List<String> lst, Map<String, TaskOrArg> args, Set<Task> deps) {
        if (lst == null) {
            return List.of();
        }
        ArrayList<TaskOrArg> ret = new ArrayList<TaskOrArg>(lst.size());
        for (String value : lst) {
            if (this.isVariable(value)) {
                String data_name = value.substring(1, value.length() - 1);
                TaskOrArg arg = args.get(data_name);
                if (arg != null) {
                    ret.add(arg);
                    continue;
                }
                Task task = this.findData(data_name);
                deps.add(task);
                ret.add(new TaskOrArg(data_name, task, null));
                continue;
            }
            ret.add(new TaskOrArg(value, null, value));
        }
        return ret;
    }

    private List<String> resolveArgs(HashStore cache, Map<Task, String> tasks, List<TaskOrArg> args) {
        ArrayList<String> ret = new ArrayList<String>();
        for (TaskOrArg toa : args) {
            if (toa.task() == null) {
                ret.add(toa.value());
                continue;
            }
            String path = tasks.get(toa.task());
            if (path == null) {
                File file = toa.task().execute();
                cache.add(toa.name(), file);
                path = file.getAbsolutePath();
            }
            ret.add(path);
        }
        return ret;
    }

    public record Lib(Artifact name, File file) {
        public Cached cacheable() {
            return new Cached(this.name, this.file.getAbsolutePath());
        }

        public record Cached(Artifact name, String file) implements Serializable
        {
            public Lib resolve() {
                return new Lib(this.name, new File(this.file));
            }
        }
    }

    private record TaskOrArg(String name, Task task, String value) {
    }
}

