/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraftforge.java_provisioner.util.OS;
import net.minecraftforge.mcmaven.impl.util.Util;
import net.minecraftforge.util.file.FileUtils;
import net.minecraftforge.util.logging.Log;
import org.apache.commons.io.IOUtils;

public final class ProcessUtils {
    private static String getStackTrace(Throwable t) {
        StringWriter string = new StringWriter();
        t.printStackTrace(new PrintWriter((Writer)string, true));
        return string.toString();
    }

    private static void getStackTrace(Throwable t, Consumer<String> lines) {
        for (String line : ProcessUtils.getStackTrace(t).split("\r?\n")) {
            lines.accept(line);
        }
    }

    public static Result runCommand(String ... args) {
        return ProcessUtils.runCommand((File)null, args);
    }

    public static Result runCommand(File workDir, String ... args) {
        ArrayList<String> lines = new ArrayList<String>();
        int exitCode = ProcessUtils.runCommand(workDir, lines::add, args);
        return new Result(lines, exitCode);
    }

    public static int runCommand(List<String> lines, String ... args) {
        return ProcessUtils.runCommand(lines::add, args);
    }

    public static int runCommand(Consumer<String> lines, String ... args) {
        return ProcessUtils.runCommand(null, lines, args);
    }

    public static int runCommand(File workDir, Consumer<String> lines, String ... args) {
        Process process;
        Log.debug("Running Command: " + String.join((CharSequence)" ", args));
        try {
            ProcessBuilder builder = new ProcessBuilder(args).redirectErrorStream(true);
            if (workDir != null) {
                builder.directory(workDir);
            }
            process = builder.start();
        }
        catch (IOException e) {
            ProcessUtils.getStackTrace(e, lines);
            return -1;
        }
        BufferedReader is = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while (process.isAlive()) {
            try {
                while (is.ready()) {
                    String line = is.readLine();
                    if (line == null) continue;
                    lines.accept(line);
                }
            }
            catch (IOException e) {
                ProcessUtils.getStackTrace(e, lines);
                process.destroy();
                return -2;
            }
        }
        return process.exitValue();
    }

    static Path getPathFromResource(String resource) {
        return ProcessUtils.getPathFromResource(resource, ProcessUtils.class.getClassLoader());
    }

    static Path getPathFromResource(String resource, ClassLoader cl) {
        URL url = cl.getResource(resource);
        if (url == null) {
            throw new IllegalStateException("Could not find " + resource + " in classloader " + String.valueOf(cl));
        }
        String str = url.toString();
        int len = resource.length();
        if ("jar".equalsIgnoreCase(url.getProtocol())) {
            str = url.getFile();
            len += 2;
        }
        str = str.substring(0, str.length() - len);
        return Paths.get(URI.create(str));
    }

    public static Result runJar(File javaHome, File workDir, File logFile, File tool, List<String> jvm, List<String> run) {
        FileUtils.ensureParent(logFile);
        PrintWriter log = new PrintWriter((Writer)new FileWriter(logFile), true);
        try {
            Object classpath = tool.getAbsolutePath();
            File classes = new File(javaHome, "libs/classes.zip");
            if (classes.exists()) {
                classpath = (String)classpath + File.pathSeparator + classes.getAbsolutePath();
            }
            String main = ProcessUtils.getMainClass(tool);
            File launcher = new File(javaHome, "bin/java" + OS.CURRENT.exe());
            Consumer<String> lines = line -> {
                Log.quiet(line);
                log.println((String)line);
            };
            lines.accept("Java:      " + launcher.getAbsolutePath());
            lines.accept("Arguments: " + run.stream().collect(Collectors.joining(", ", "'", "'")));
            lines.accept("JVMArgs:   " + jvm.stream().collect(Collectors.joining(", ", "'", "'")));
            lines.accept("Classpath: " + (String)classpath);
            lines.accept("Main:      " + main);
            lines.accept("Work Dir:  " + workDir.getAbsolutePath());
            log.println("====================================");
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(launcher.getAbsolutePath());
            args.addAll(jvm);
            args.add("-classpath");
            args.add(classpath);
            args.add(main);
            args.addAll(run);
            ArrayList<String> consoleLog = new ArrayList<String>();
            lines = line -> {
                consoleLog.add((String)line);
                log.println((String)line);
            };
            int ret = ProcessUtils.runCommand(workDir, lines, (String[])args.toArray(String[]::new));
            System.currentTimeMillis();
            log.flush();
            Result result = new Result(consoleLog, ret);
            log.close();
            return result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    log.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return (Result)ProcessUtils.sneak(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File recompileJar(File javaHome, List<File> classpath, File sourcesJar, File outputJar, File workDir) {
        String classpathString = ProcessUtils.makeClasspathString(classpath);
        File sourcesOutput = new File(workDir, "recompileSources");
        try {
            FileUtils.ensureParent(sourcesOutput);
            try (ZipInputStream zin = new ZipInputStream(new FileInputStream(sourcesJar));){
                ZipEntry entry;
                while ((entry = zin.getNextEntry()) != null) {
                    File entryFile = new File(sourcesOutput, entry.getName());
                    FileUtils.ensureParent(entryFile);
                    if (entry.isDirectory()) {
                        entryFile.mkdirs();
                        continue;
                    }
                    try (FileOutputStream fos = new FileOutputStream(entryFile);){
                        IOUtils.copy((InputStream)zin, (OutputStream)fos);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        StringBuilder sourcePath = new StringBuilder();
        ArrayList<File> nonSourceFiles = new ArrayList<File>();
        Iterator<File> sourceFiles = FileUtils.listFiles(sourcesOutput).iterator();
        while (sourceFiles.hasNext()) {
            File sourceFile = sourceFiles.next();
            String absolutePath = sourceFile.getAbsolutePath();
            if (absolutePath.endsWith(".java")) {
                sourcePath.append(ProcessUtils.wrap(sourceFile.getAbsolutePath().replace('\\', '/')));
                if (!sourceFiles.hasNext()) continue;
                sourcePath.append("\n\t");
                continue;
            }
            nonSourceFiles.add(sourceFile);
        }
        File outputClasses = new File(workDir, "classes");
        FileUtils.ensure(outputClasses);
        List<String> args = List.of("-nowarn", "-d " + ProcessUtils.wrap(outputClasses.getAbsolutePath().replace('\\', '/')), "-classpath " + ProcessUtils.wrap(classpathString), sourcePath.toString());
        Result process = ProcessUtils.runJavac(javaHome, workDir, new File(outputJar.getAbsolutePath() + ".log"), args);
        if (process.exitCode != 0) {
            Log.error("Javac failed to execute! Exit code " + process.exitCode);
            Log.error("--- BEGIN JAVAC LOG ---");
            process.lines.forEach(Log::error);
            Log.error("--- END JAVAC LOG ---");
            throw new RuntimeException("Javac failed to execute! Exit code " + process.exitCode);
        }
        try {
            File file = FileUtils.makeJar(outputClasses, sourcesOutput, nonSourceFiles, outputJar);
            return file;
        }
        finally {
            FileUtils.deleteOnExit(sourcesOutput);
            FileUtils.deleteOnExit(outputClasses);
        }
    }

    private static String makeClasspathString(List<File> classpath) {
        StringBuilder classpathArg = new StringBuilder().append("");
        Iterator<File> it = classpath.iterator();
        while (it.hasNext()) {
            File file = it.next();
            classpathArg.append(file.getAbsolutePath().replace('\\', '/'));
            if (!it.hasNext()) continue;
            classpathArg.append(File.pathSeparator);
        }
        return classpathArg.toString();
    }

    private static Result runJavac(File javaHome, File workDir, File logFile, List<String> args) {
        FileUtils.ensureParent(logFile);
        PrintWriter log = new PrintWriter((Writer)new FileWriter(logFile), true);
        try {
            String argsAll = Util.make(new StringBuilder(), s -> {
                Iterator it = args.iterator();
                while (it.hasNext()) {
                    s.append((String)it.next());
                    if (!it.hasNext()) continue;
                    s.append('\n');
                }
            }).toString();
            File argsFile = new File(workDir, "recompile_args.txt");
            FileUtils.ensureParent(argsFile);
            try (FileOutputStream os = new FileOutputStream(argsFile);){
                os.write(argsAll.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                ProcessUtils.sneak(e);
            }
            String argsString = "@" + argsFile.getAbsolutePath().replace('\\', '/');
            File launcher = new File(javaHome, "bin/javac" + OS.CURRENT.exe());
            Consumer<String> lines = line -> {
                Log.quiet(line);
                log.println((String)line);
            };
            lines.accept("Java Compiler: " + launcher.getAbsolutePath());
            lines.accept("Argument File: " + argsFile.getAbsolutePath());
            log.println("Arguments:");
            log.println(argsAll);
            lines.accept("====================================");
            ArrayList<Object> command = new ArrayList<Object>();
            command.add(launcher.getAbsolutePath().replace('\\', '/'));
            command.add(argsString);
            ArrayList<String> consoleLog = new ArrayList<String>();
            lines = line -> {
                consoleLog.add((String)line);
                log.println((String)line);
            };
            int ret = ProcessUtils.runCommand(workDir, lines, (String[])command.toArray(String[]::new));
            System.currentTimeMillis();
            log.flush();
            Result result = new Result(consoleLog, ret);
            log.close();
            return result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    log.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return (Result)ProcessUtils.sneak(e);
            }
        }
    }

    private static String getMainClass(File tool) throws IOException {
        try (JarFile jar = new JarFile(tool);){
            String string = jar.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            return string;
        }
    }

    private static String wrap(String s) {
        return s == null ? null : "\"" + s + "\"";
    }

    private static <R, E extends Throwable> R sneak(Throwable t) throws E {
        throw t;
    }

    public static class Result {
        public final List<String> lines;
        public final int exitCode;

        private Result(List<String> lines, int exitCode) {
            this.lines = Collections.unmodifiableList(lines);
            this.exitCode = exitCode;
        }
    }
}

