/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.cli;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.mcmaven.impl.GlobalOptions;
import net.minecraftforge.mcmaven.impl.MinecraftMaven;
import net.minecraftforge.util.logging.Log;

class MavenTask {
    MavenTask() {
    }

    static void run(String[] args) throws Exception {
        Log.enabled = Log.Level.INFO;
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        AbstractOptionSpec helpO = parser.accepts("help", "Displays this help message and exits").forHelp();
        ArgumentAcceptingOptionSpec<File> cacheO = parser.accepts("cache", "Directory to store data needed for this program").withRequiredArg().ofType(File.class).defaultsTo(new File("cache"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<File> jdkCacheO = parser.accepts("jdk-cache", "Directory to store jdks downloaded from the disoco api").withRequiredArg().ofType(File.class).defaultsTo(new File("cache/jdks"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<String> versionO = parser.accepts("version", "The specific artifact version to generate").withOptionalArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<String> artifactO = parser.accepts("artifact", "The artifact to attempt to generate, see the code for supported formats").withRequiredArg().ofType(String.class).defaultsTo("net.minecraftforge:forge", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<File> outputO = parser.accepts("output", "Root directory to generate the maven repository").withRequiredArg().ofType(File.class).defaultsTo(new File("output"), (File[])new File[0]);
        AbstractOptionSpec offlineO = parser.accepts("offline", "Do not attempt to download anything (allows offline operations, if possible)").forHelp();
        OptionSpecBuilder cacheOnlyO = parser.accepts("cache-only", "Only use caches, fail if any downloads need to occur or if a task needs to do work");
        HashMap<String, OptionSpecBuilder> shorthandOptions = new HashMap<String, OptionSpecBuilder>();
        Map<String, String> artifacts = Map.of("forge", "net.minecraftforge:forge", "fml", "net.minecraftforge:fmlonly", "mc", "net.minecraft:joined", "client", "net.minecraft:client", "server", "net.minecraft:server");
        for (Map.Entry<String, String> entry : artifacts.entrySet()) {
            String key2 = entry.getKey();
            OptionSpecBuilder option2 = parser.accepts(entry.getKey(), "Shorthand for --artifact " + entry.getValue());
            shorthandOptions.put(key2, option2);
            option2.availableUnless(artifactO, new OptionSpec[0]);
        }
        shorthandOptions.forEach((key, option) -> {
            for (String other : shorthandOptions.keySet()) {
                if (other.equals(key)) continue;
                option.availableUnless(other, new String[0]);
            }
        });
        OptionSet options = parser.parse(args);
        if (options.has(helpO)) {
            parser.printHelpOn(Log.INFO);
            Log.release();
            return;
        }
        if (options.has(offlineO)) {
            GlobalOptions.setOffline();
        }
        if (options.has(cacheOnlyO)) {
            GlobalOptions.setCacheOnly();
        }
        File output = options.valueOf(outputO);
        File cache = options.valueOf(cacheO);
        File jdkCache = !options.has(cacheO) || options.has(jdkCacheO) ? options.valueOf(jdkCacheO) : new File(cache, "jdks");
        String artifact = options.valueOf(artifactO);
        for (Map.Entry<String, String> entry : artifacts.entrySet()) {
            if (!options.has(entry.getKey())) continue;
            artifact = entry.getValue();
        }
        String version = options.valueOf(versionO);
        MinecraftMaven mcmaven = new MinecraftMaven(output, cache, jdkCache);
        mcmaven.run(artifact, version);
    }
}

