/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mcmaven.impl.util;

import java.io.ByteArrayOutputStream;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.minecraftforge.mcmaven.impl.util.Artifact;
import net.minecraftforge.mcmaven.impl.util.Util;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class POMBuilder {
    private final String group;
    private final String name;
    private final String version;
    private final Dependencies dependencies = new Dependencies();
    @Nullable
    private String description;
    private boolean preferGradleModule;

    public POMBuilder(Artifact artifact) {
        this(artifact.getGroup(), artifact.getName(), artifact.getVersion());
    }

    public POMBuilder(String group, String name, String version) {
        this.group = group;
        this.name = name;
        this.version = version;
    }

    public POMBuilder description(String description) {
        this.description = description;
        return this;
    }

    public POMBuilder dependencies(Consumer<? super Dependencies> configurator) {
        configurator.accept(this.dependencies);
        return this;
    }

    public POMBuilder preferGradleModule() {
        this.preferGradleModule = true;
        return this;
    }

    public String build() throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element project = doc.createElement("project");
        project.setAttribute("xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd");
        project.setAttribute("xmlns", "http://maven.apache.org/POM/4.0.0");
        project.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        doc.appendChild(project);
        if (this.preferGradleModule) {
            project.appendChild(doc.createComment(" do_not_remove: published-with-gradle-metadata "));
        }
        POMBuilder.set(doc, project, "modelVersion", "4.0.0");
        POMBuilder.set(doc, project, "groupId", this.group);
        POMBuilder.set(doc, project, "artifactId", this.name);
        POMBuilder.set(doc, project, "version", this.version);
        POMBuilder.set(doc, project, "name", this.name);
        if (this.description != null) {
            POMBuilder.set(doc, project, "description", this.description);
        }
        if (!this.dependencies.dependencies.isEmpty()) {
            Element dependencies = doc.createElement("dependencies");
            for (Dependencies.Dependency dependency : this.dependencies.dependencies) {
                Element dep = doc.createElement("dependency");
                POMBuilder.set(doc, dep, "groupId", dependency.artifact.getGroup());
                POMBuilder.set(doc, dep, "artifactId", dependency.artifact.getName());
                POMBuilder.set(doc, dep, "version", dependency.artifact.getVersion());
                String classifier = dependency.artifact.getClassifier();
                String extension = dependency.artifact.getExtension();
                if (classifier != null) {
                    POMBuilder.set(doc, dep, "classifier", classifier);
                }
                if (extension != null && !"jar".equals(extension)) {
                    POMBuilder.set(doc, dep, "type", extension);
                }
                if (dependency.scope != null) {
                    POMBuilder.set(doc, dep, "scope", dependency.scope.toString());
                }
                dependencies.appendChild(dep);
            }
            project.appendChild(dependencies);
        }
        doc.normalizeDocument();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(doc), new StreamResult(output));
        return output.toString();
    }

    private static void set(Document doc, Element parent, String name, String value) {
        Element description = doc.createElement(name);
        description.appendChild(doc.createTextNode(value));
        parent.appendChild(description);
    }

    public static final class Dependencies {
        private final Set<Dependency> dependencies = new LinkedHashSet<Dependency>();

        private Dependencies() {
        }

        public Dependency add(Artifact artifact) {
            return this.add(artifact, Dependency.Scope.COMPILE);
        }

        public Dependency add(Artifact artifact, @Nullable Dependency.Scope scope) {
            Dependency dep = new Dependency(artifact, scope);
            this.dependencies.add(dep);
            return dep;
        }

        public record Dependency(Artifact artifact, @Nullable Scope scope) implements Comparable<Dependency>
        {
            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object obj) {
                Scope scope;
                Artifact artifact;
                if (!(obj instanceof Dependency)) return false;
                Dependency dependency = (Dependency)obj;
                try {
                    Artifact artifact2;
                    artifact = artifact2 = dependency.artifact();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Scope scope2 = scope = dependency.scope();
                if (!Objects.equals(this.artifact, artifact)) return false;
                if (!Objects.equals((Object)this.scope, (Object)scope2)) return false;
                return true;
            }

            @Override
            public int compareTo(Dependency o) {
                int ret = Util.compare(this.artifact, o.artifact);
                return ret != 0 ? ret : Util.compare(this.scope, o.scope);
            }

            public static enum Scope {
                COMPILE,
                PROVIDED,
                RUNTIME,
                TEST,
                SYSTEM;


                public String toString() {
                    return super.toString().toLowerCase(Locale.ENGLISH);
                }
            }
        }
    }
}

