/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.util.logging;

import java.io.PrintStream;
import net.minecraftforge.util.logging.AbstractLogger;
import net.minecraftforge.util.logging.DefaultLogger;
import org.jetbrains.annotations.Nullable;

public interface Logger {
    public static Logger create() {
        return new DefaultLogger();
    }

    public static Logger create(String tag) {
        return new DefaultLogger(tag);
    }

    @Nullable
    default public Level getEnabled() {
        return AbstractLogger.getEnabledImpl();
    }

    default public void setEnabled(@Nullable Level level) {
        AbstractLogger.setEnabledImpl(level);
    }

    default public boolean isEnabled(Level level) {
        return AbstractLogger.isEnabledImpl(level);
    }

    default public byte push() {
        return AbstractLogger.pushImpl();
    }

    default public byte pop() {
        return AbstractLogger.popImpl();
    }

    default public byte pop(byte indent) {
        return AbstractLogger.popImpl(indent);
    }

    default public boolean isCapturing() {
        return AbstractLogger.isCapturingImpl();
    }

    default public void capture() {
        AbstractLogger.captureImpl();
    }

    default public void drop() {
        AbstractLogger.dropImpl();
    }

    default public void release() {
        AbstractLogger.releaseImpl();
    }

    default public PrintStream getLog(@Nullable Level level) {
        if (level == null) {
            return AbstractLogger.EMPTY;
        }
        switch (level) {
            case DEBUG: {
                return this.getDebug();
            }
            case QUIET: {
                return this.getQuiet();
            }
            case INFO: {
                return this.getInfo();
            }
            case WARN: {
                return this.getWarn();
            }
            case ERROR: {
                return this.getError();
            }
            case FATAL: {
                return this.getFatal();
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)level));
    }

    default public void log(Level level) {
        this.getLog(level).println();
    }

    default public void log(Level level, String message) {
        this.getLog(level).println(message);
    }

    default public void log(Level level, Object message) {
        this.getLog(level).println(message);
    }

    default public void log(Level level, Throwable throwable) {
        throwable.printStackTrace(this.getLog(level));
    }

    default public void log(Level level, Object message, Throwable throwable) {
        PrintStream log = this.getLog(level);
        log.println(message);
        throwable.printStackTrace(log);
    }

    default public void log(Level level, String message, Throwable throwable) {
        PrintStream log = this.getLog(level);
        log.println(message);
        throwable.printStackTrace(log);
    }

    public PrintStream getDebug();

    default public void debug() {
        this.getDebug().println();
    }

    default public void debug(String message) {
        this.getDebug().println(message);
    }

    default public void debug(Object message) {
        this.getDebug().println(message);
    }

    default public void debug(Throwable throwable) {
        throwable.printStackTrace(this.getDebug());
    }

    default public void debug(String message, Throwable throwable) {
        this.debug(message);
        this.debug(throwable);
    }

    default public void debug(Object message, Throwable throwable) {
        this.debug(message);
        this.debug(throwable);
    }

    public PrintStream getQuiet();

    default public void quiet() {
        this.getQuiet().println();
    }

    default public void quiet(String message) {
        this.getQuiet().println(message);
    }

    default public void quiet(Object message) {
        this.getQuiet().println(message);
    }

    default public void quiet(Throwable throwable) {
        throwable.printStackTrace(this.getQuiet());
    }

    default public void quiet(String message, Throwable throwable) {
        this.quiet(message);
        this.quiet(throwable);
    }

    default public void quiet(Object message, Throwable throwable) {
        this.quiet(message);
        this.quiet(throwable);
    }

    public PrintStream getInfo();

    default public void info() {
        this.getInfo().println();
    }

    default public void info(String message) {
        this.getInfo().println(message);
    }

    default public void info(Object message) {
        this.getInfo().println(message);
    }

    default public void info(Throwable throwable) {
        throwable.printStackTrace(this.getInfo());
    }

    default public void info(String message, Throwable throwable) {
        this.info(message);
        this.info(throwable);
    }

    default public void info(Object message, Throwable throwable) {
        this.info(message);
        this.info(throwable);
    }

    public PrintStream getWarn();

    default public void warn() {
        this.getWarn().println();
    }

    default public void warn(String message) {
        this.getWarn().println(message);
    }

    default public void warn(Object message) {
        this.getWarn().println(message);
    }

    default public void warn(Throwable throwable) {
        throwable.printStackTrace(this.getWarn());
    }

    default public void warn(String message, Throwable throwable) {
        this.warn(message);
        this.warn(throwable);
    }

    default public void warn(Object message, Throwable throwable) {
        this.warn(message);
        this.warn(throwable);
    }

    public PrintStream getError();

    default public void error() {
        this.getError().println();
    }

    default public void error(String message) {
        this.getError().println(message);
    }

    default public void error(Object message) {
        this.getError().println(message);
    }

    default public void error(Throwable throwable) {
        throwable.printStackTrace(this.getError());
    }

    default public void error(String message, Throwable throwable) {
        this.error(message);
        this.error(throwable);
    }

    default public void error(Object message, Throwable throwable) {
        this.error(message);
        this.error(throwable);
    }

    public PrintStream getFatal();

    default public void fatal() {
        this.getFatal().println();
    }

    default public void fatal(String message) {
        this.getFatal().println(message);
    }

    default public void fatal(Object message) {
        this.getFatal().println(message);
    }

    default public void fatal(Throwable throwable) {
        throwable.printStackTrace(this.getFatal());
    }

    default public void fatal(String message, Throwable throwable) {
        this.fatal(message);
        this.fatal(throwable);
    }

    default public void fatal(Object message, Throwable throwable) {
        this.fatal(message);
        this.fatal(throwable);
    }

    public static enum Level {
        DEBUG,
        QUIET,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

