/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.util.logging;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.function.Consumer;
import net.minecraftforge.util.logging.AbstractLogger;
import net.minecraftforge.util.logging.LogConsumer;
import net.minecraftforge.util.logging.Logger;

interface DelegatePrintStream {
    public static final Empty EMPTY = new Empty();

    public Consumer<? super String> getDelegate();

    public static final class Empty
    extends PrintStream
    implements DelegatePrintStream {
        private Empty() {
            super(new OutputStream(){

                @Override
                public void write(int b) {
                }
            });
        }

        @Override
        public boolean checkError() {
            return false;
        }

        @Override
        protected void clearError() {
        }

        @Override
        public Consumer<? super String> getDelegate() {
            return s -> {};
        }
    }

    public static final class Capturing
    extends PrintStream
    implements DelegatePrintStream {
        private final Consumer<? super String> delegate;

        public Capturing(final AbstractLogger logger, final Logger.Level level, final Consumer<? super String> output) {
            super(new OutputStream(){
                private final Consumer<? super String> consumer;
                private StringBuffer buffer;
                private char last;
                {
                    this.consumer = new LogConsumer(level, output);
                    this.buffer = new StringBuffer(512);
                    this.last = '\u0000';
                }

                @Override
                public void write(int b) {
                    this.write((char)b);
                }

                private void write(char c) {
                    if (c == '\n' || c == '\r') {
                        if (this.last != '\r') {
                            this.consumer.accept(this.buffer.insert(0, logger.getIndentationImpl() + logger.tag).toString());
                            this.buffer = new StringBuffer(512);
                        }
                    } else {
                        this.buffer.append(c);
                    }
                    this.last = c;
                }
            });
            this.delegate = output;
        }

        @Override
        public Consumer<? super String> getDelegate() {
            return this.delegate;
        }
    }
}

