/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.util.logging;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraftforge.util.logging.DelegatePrintStream;
import net.minecraftforge.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLogger
implements Logger {
    @Nullable
    private Logger.Level enabled;
    private static final String INDENT_STRING = "  ";
    private static final String[] INDENT_CACHE = new String[127];
    private byte indentLevel;
    @Nullable
    private List<Map.Entry<Logger.Level, String>> captured;
    static final DelegatePrintStream.Empty EMPTY;

    protected AbstractLogger() {
        this(Logger.Level.INFO, 0);
    }

    protected AbstractLogger(byte indentLevel) {
        this(Logger.Level.INFO, indentLevel);
    }

    protected AbstractLogger(Logger.Level enabled) {
        this(enabled, 0);
    }

    protected AbstractLogger(Logger.Level enabled, byte indentLevel) {
        this.enabled = enabled;
        this.indentLevel = indentLevel;
    }

    @Override
    @Nullable
    public final Logger.Level getEnabled() {
        return this.enabled;
    }

    @Override
    public final void setEnabled(@Nullable Logger.Level level) {
        this.enabled = level;
    }

    @Override
    public final byte push() {
        byte by = this.indentLevel;
        this.indentLevel = (byte)(by + 1);
        return by;
    }

    @Override
    public final byte pop() {
        this.indentLevel = (byte)(this.indentLevel - 1);
        if (this.indentLevel < 0) {
            throw new IllegalStateException("Cannot pop Log below 0");
        }
        return this.indentLevel;
    }

    @Override
    public final byte pop(byte indent) {
        if (indent < 0) {
            throw new IllegalArgumentException("Cannot pop Log below 0");
        }
        this.indentLevel = indent;
        return this.indentLevel;
    }

    @Override
    public final String getIndentation() {
        String ret = INDENT_CACHE[this.indentLevel];
        return ret == null ? AbstractLogger.getIndentation(this.indentLevel) : ret;
    }

    private static String getIndentation(byte indent) {
        StringBuilder builder = new StringBuilder(INDENT_STRING.length() * indent);
        for (int i = 0; i < indent; ++i) {
            builder.append(INDENT_STRING);
        }
        return builder.toString();
    }

    @Override
    public final boolean isCapturing() {
        return this.captured != null;
    }

    @Override
    public final void capture() {
        if (this.captured != null) {
            return;
        }
        this.captured = new ArrayList<Map.Entry<Logger.Level, String>>(128);
    }

    final void tryCapture(Consumer<? super String> logger, Logger.Level level, String message) {
        if (this.captured != null) {
            this.captured.add(new AbstractMap.SimpleImmutableEntry<Logger.Level, String>(level, message));
        } else {
            logger.accept(message);
        }
    }

    @Override
    public final void drop() {
        this.captured = null;
    }

    @Override
    public final void release() {
        this.release(this::logDirectly);
    }

    @Override
    public final void release(BiConsumer<Logger.Level, String> consumer) {
        if (this.captured == null) {
            return;
        }
        Iterator<Map.Entry<Logger.Level, String>> itor = this.captured.iterator();
        this.captured = null;
        while (itor.hasNext()) {
            Map.Entry<Logger.Level, String> capture = itor.next();
            consumer.accept(capture.getKey(), capture.getValue());
        }
    }

    private void logDirectly(Logger.Level level, String message) {
        ((DelegatePrintStream)((Object)this.getLog(level))).getDelegate().accept(message);
    }

    static {
        AbstractLogger.INDENT_CACHE[0] = "";
        AbstractLogger.INDENT_CACHE[1] = INDENT_STRING;
        EMPTY = DelegatePrintStream.EMPTY;
    }
}

