/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.util.logging;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraftforge.util.logging.DelegatePrintStream;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public final class Log {
    @Nullable
    public static Level enabled = Level.INFO;
    public static final PrintStream EMPTY = DelegatePrintStream.EMPTY;
    public static final PrintStream DEBUG = new DelegatePrintStream.Capturing(Level.DEBUG, System.out);
    public static final PrintStream QUIET = new DelegatePrintStream.Capturing(Level.QUIET, System.out);
    public static final PrintStream INFO = new DelegatePrintStream.Capturing(Level.INFO, System.out);
    public static final PrintStream WARN = new DelegatePrintStream.Capturing(Level.WARN, System.out);
    public static final PrintStream ERROR = new DelegatePrintStream.Capturing(Level.ERROR, System.err);
    public static final PrintStream FATAL = new DelegatePrintStream.Capturing(Level.FATAL, System.err);
    private static final String INDENT_STRING = "  ";
    private static final String[] INDENT_CACHE = new String[127];
    private static byte indentLevel = 0;
    private static @UnknownNullability List<CapturedMessage> CAPTURED;

    public static byte push() {
        byte by = indentLevel;
        indentLevel = (byte)(by + 1);
        return by;
    }

    public static void pop() {
        if ((indentLevel = (byte)(indentLevel - 1)) < 0) {
            throw new IllegalStateException("Cannot pop Log below 0");
        }
    }

    public static void pop(byte indent) {
        if (indent < 0) {
            throw new IllegalArgumentException("Cannot pop Log below 0");
        }
        indentLevel = indent;
    }

    static String getIndentation() {
        String ret = INDENT_CACHE[indentLevel];
        return ret == null ? Log.getIndentation(indentLevel) : ret;
    }

    private static String getIndentation(byte indent) {
        StringBuilder builder = new StringBuilder(INDENT_STRING.length() * indent);
        for (int i = 0; i < indent; ++i) {
            builder.append(INDENT_STRING);
        }
        return builder.toString();
    }

    public static boolean isCapturing() {
        return CAPTURED != null;
    }

    public static void capture() {
        if (CAPTURED != null) {
            return;
        }
        CAPTURED = new ArrayList<CapturedMessage>(128);
    }

    static void tryCapture(Consumer<String> logger, Level level, String message) {
        if (CAPTURED != null) {
            CAPTURED.add(new CapturedMessage(level, message));
        } else {
            logger.accept(message);
        }
    }

    public static void drop() {
        CAPTURED = null;
    }

    public static void release() {
        Log.release(Log::logCaptured);
    }

    public static void release(BiConsumer<Level, String> consumer) {
        if (CAPTURED == null) {
            return;
        }
        Iterator<CapturedMessage> itor = CAPTURED.iterator();
        CAPTURED = null;
        while (itor.hasNext()) {
            CapturedMessage capture = itor.next();
            consumer.accept(capture.level, capture.message);
        }
    }

    private static void logCaptured(Level level, String message) {
        ((DelegatePrintStream)((Object)Log.getLog(level))).getDelegate().println(message);
    }

    public static PrintStream getLog(@Nullable Level level) {
        if (level == null) {
            return EMPTY;
        }
        switch (level) {
            case DEBUG: {
                return DEBUG;
            }
            case QUIET: {
                return QUIET;
            }
            case INFO: {
                return INFO;
            }
            case WARN: {
                return WARN;
            }
            case ERROR: {
                return ERROR;
            }
            case FATAL: {
                return FATAL;
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)level));
    }

    @Deprecated
    public static void log(Level level) {
        Log.getLog(level).println();
    }

    @Deprecated
    public static void log(Level level, Object message) {
        Log.getLog(level).println(message);
    }

    @Deprecated
    public static void log(Level level, Throwable throwable) {
        throwable.printStackTrace(Log.getLog(level));
    }

    @Deprecated
    public static void log(Level level, Object message, Throwable throwable) {
        PrintStream log = Log.getLog(level);
        log.println(message);
        throwable.printStackTrace(log);
    }

    public static void debug() {
        DEBUG.println();
    }

    public static void debug(String message) {
        DEBUG.println(message);
    }

    public static void debug(Object message) {
        DEBUG.println(message);
    }

    public static void debug(Throwable throwable) {
        throwable.printStackTrace(DEBUG);
    }

    public static void debug(String message, Throwable throwable) {
        Log.debug(message);
        Log.debug(throwable);
    }

    public static void debug(Object message, Throwable throwable) {
        Log.debug(message);
        Log.debug(throwable);
    }

    public static void quiet() {
        QUIET.println();
    }

    public static void quiet(String message) {
        QUIET.println(message);
    }

    public static void quiet(Object message) {
        QUIET.println(message);
    }

    public static void quiet(Throwable throwable) {
        throwable.printStackTrace(QUIET);
    }

    public static void quiet(String message, Throwable throwable) {
        Log.quiet(message);
        Log.quiet(throwable);
    }

    public static void quiet(Object message, Throwable throwable) {
        Log.quiet(message);
        Log.quiet(throwable);
    }

    public static void info() {
        INFO.println();
    }

    public static void info(String message) {
        INFO.println(message);
    }

    public static void info(Object message) {
        INFO.println(message);
    }

    public static void info(Throwable throwable) {
        throwable.printStackTrace(INFO);
    }

    public static void info(String message, Throwable throwable) {
        Log.info(message);
        Log.info(throwable);
    }

    public static void info(Object message, Throwable throwable) {
        Log.info(message);
        Log.info(throwable);
    }

    public static void warn() {
        WARN.println();
    }

    public static void warn(String message) {
        WARN.println(message);
    }

    public static void warn(Object message) {
        WARN.println(message);
    }

    public static void warn(Throwable throwable) {
        throwable.printStackTrace(WARN);
    }

    public static void warn(String message, Throwable throwable) {
        Log.warn(message);
        Log.warn(throwable);
    }

    public static void warn(Object message, Throwable throwable) {
        Log.warn(message);
        Log.warn(throwable);
    }

    public static void error() {
        ERROR.println();
    }

    public static void error(String message) {
        ERROR.println(message);
    }

    public static void error(Object message) {
        ERROR.println(message);
    }

    public static void error(Throwable throwable) {
        throwable.printStackTrace(ERROR);
    }

    public static void error(String message, Throwable throwable) {
        Log.error(message);
        Log.error(throwable);
    }

    public static void error(Object message, Throwable throwable) {
        Log.error(message);
        Log.error(throwable);
    }

    public static void fatal() {
        FATAL.println();
    }

    public static void fatal(String message) {
        FATAL.println(message);
    }

    public static void fatal(Object message) {
        FATAL.println(message);
    }

    public static void fatal(Throwable throwable) {
        throwable.printStackTrace(FATAL);
    }

    public static void fatal(String message, Throwable throwable) {
        Log.fatal(message);
        Log.fatal(throwable);
    }

    public static void fatal(Object message, Throwable throwable) {
        Log.fatal(message);
        Log.fatal(throwable);
    }

    private Log() {
    }

    static {
        Log.INDENT_CACHE[0] = "";
        Log.INDENT_CACHE[1] = INDENT_STRING;
    }

    public static enum Level {
        DEBUG,
        QUIET,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }

    private static final class CapturedMessage {
        private final Level level;
        private final String message;

        private CapturedMessage(Level level, String message) {
            this.level = level;
            this.message = message;
        }
    }
}

