/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.util.logging;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import net.minecraftforge.util.logging.Log;

class DelegatePrintStream
extends PrintStream {
    static final PrintStream EMPTY = new EmptyPrintStream();
    private final Log.Level level;
    private boolean shouldIndent;

    DelegatePrintStream(Log.Level level, PrintStream delegate) {
        super(delegate);
        this.level = level;
    }

    boolean isEnabled() {
        return this.level != null && Log.enabled != null && this.level.compareTo(Log.enabled) >= 0;
    }

    private void printPre() {
        if (!this.shouldIndent) {
            return;
        }
        this.shouldIndent = false;
        super.print(Log.getIndentation());
    }

    private void printPost(boolean newline) {
        if (!newline) {
            return;
        }
        this.shouldIndent = true;
    }

    public void flush() {
        if (!this.isEnabled()) {
            return;
        }
        super.flush();
    }

    public void close() {
    }

    protected void setError() {
        if (!this.isEnabled()) {
            return;
        }
        super.setError();
    }

    public void write(int b) {
        if (!this.isEnabled()) {
            return;
        }
        super.write(b);
    }

    public void write(byte[] b) throws IOException {
        if (!this.isEnabled()) {
            return;
        }
        super.write(b);
    }

    public void write(byte[] buf, int off, int len) {
        if (!this.isEnabled()) {
            return;
        }
        super.write(buf, off, len);
    }

    public void print(boolean b) {
        if (!this.isEnabled()) {
            return;
        }
        this.printPre();
        super.print(b);
    }

    public void print(char c) {
        this.print(String.valueOf(c));
    }

    public void print(int i) {
        this.print(String.valueOf(i));
    }

    public void print(long l) {
        this.print(String.valueOf(l));
    }

    public void print(float f) {
        this.print(String.valueOf(f));
    }

    public void print(double d) {
        this.print(String.valueOf(d));
    }

    public void print(char[] s) {
        if (!this.isEnabled()) {
            return;
        }
        super.print(s);
        if (s[s.length - 1] == '\n') {
            super.print(Log.getIndentation());
        }
    }

    public void print(String s) {
        if (!this.isEnabled()) {
            return;
        }
        this.printPre();
        super.print(s);
        this.printPost(s.indexOf(10) == s.length() - 1);
    }

    public void print(Object obj) {
        this.print(String.valueOf(obj));
    }

    public void println() {
        if (!this.isEnabled()) {
            return;
        }
        this.printPre();
        super.println();
        this.printPost(true);
    }

    public void println(boolean x) {
        if (!this.isEnabled()) {
            return;
        }
        this.printPre();
        super.println(x);
        this.printPost(true);
    }

    public void println(char x) {
        this.println(String.valueOf(x));
    }

    public void println(int x) {
        this.println(String.valueOf(x));
    }

    public void println(long x) {
        this.println(String.valueOf(x));
    }

    public void println(float x) {
        this.println(String.valueOf(x));
    }

    public void println(double x) {
        this.println(String.valueOf(x));
    }

    public void println(char[] x) {
        if (!this.isEnabled()) {
            return;
        }
        this.printPre();
        super.println(x);
        this.printPost(true);
    }

    public void println(String x) {
        if (!this.isEnabled()) {
            return;
        }
        this.printPre();
        super.println(x);
        this.printPost(true);
    }

    public void println(Object x) {
        this.println(String.valueOf(x));
    }

    public PrintStream printf(String format, Object ... args) {
        return this.isEnabled() ? super.printf(format, args) : this;
    }

    public PrintStream printf(Locale l, String format, Object ... args) {
        return this.isEnabled() ? super.printf(l, format, args) : this;
    }

    public PrintStream format(String format, Object ... args) {
        return this.isEnabled() ? super.format(format, args) : this;
    }

    public PrintStream format(Locale l, String format, Object ... args) {
        return this.isEnabled() ? super.format(l, format, args) : this;
    }

    public PrintStream append(CharSequence csq) {
        return this.isEnabled() ? super.append(csq) : this;
    }

    public PrintStream append(CharSequence csq, int start, int end) {
        if (this.isEnabled()) {
            super.append(csq, start, end);
            if (csq.charAt(end) == '\n') {
                super.print(Log.getIndentation());
            }
        }
        return this;
    }

    public PrintStream append(char c) {
        return this.isEnabled() ? super.append(c) : this;
    }

    private static final class EmptyPrintStream
    extends DelegatePrintStream {
        EmptyPrintStream() {
            super(null, System.err);
        }

        boolean isEnabled() {
            return false;
        }

        public boolean checkError() {
            return false;
        }

        protected void clearError() {
        }
    }
}

