/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.util.logging;

import java.io.PrintStream;
import java.util.EnumMap;
import net.minecraftforge.util.logging.DelegatePrintStream;

public final class Log {
    public static Level enabled = Level.INFO;
    private static final EnumMap<Level, PrintStream> STREAMS = new EnumMap(Level.class);
    public static final PrintStream DEBUG = Log.streamOf(Level.DEBUG, System.out);
    public static final PrintStream QUIET = Log.streamOf(Level.QUIET, System.out);
    public static final PrintStream INFO = Log.streamOf(Level.INFO, System.out);
    public static final PrintStream WARN = Log.streamOf(Level.WARN, System.out);
    public static final PrintStream ERROR = Log.streamOf(Level.ERROR, System.err);
    public static final PrintStream FATAL = Log.streamOf(Level.FATAL, System.err);
    private static final String INDENT_STRING = "  ";
    private static byte indent = 0;

    private static PrintStream streamOf(Level level, PrintStream delegate) {
        DelegatePrintStream ret = new DelegatePrintStream(level, delegate);
        STREAMS.put(level, ret);
        return ret;
    }

    public static int push() {
        indent = (byte)(indent + 1);
        return indent;
    }

    public static void pop() {
        if ((indent = (byte)(indent - 1)) < 0) {
            throw new IllegalStateException("Cannot pop logger below 0");
        }
    }

    public static void setIndent(byte indent) {
        if (indent < 0) {
            throw new IllegalStateException("Cannot pop logger below 0");
        }
        Log.indent = indent;
    }

    static String getIndentation() {
        if (indent == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(INDENT_STRING.length() * indent);
        for (int i = 0; i < indent; ++i) {
            builder.append(INDENT_STRING);
        }
        return builder.toString();
    }

    public static PrintStream getLog(Level level) {
        return level != null ? STREAMS.get((Object)level) : DelegatePrintStream.EMPTY;
    }

    public static void log(Level level, Object message) {
        Log.getLog(level).println(message);
    }

    public static void log(Level level, Throwable throwable) {
        throwable.printStackTrace(Log.getLog(level));
    }

    public static void log(Level level, Object message, Throwable throwable) {
        Log.log(level, message);
        Log.log(level, throwable);
    }

    public static void debug(Object message) {
        Log.log(Level.DEBUG, message);
    }

    public static void debug(Throwable throwable) {
        Log.log(Level.DEBUG, throwable);
    }

    public static void debug(Object message, Throwable throwable) {
        Log.log(Level.DEBUG, message, throwable);
    }

    public static void quiet(Object message) {
        Log.log(Level.QUIET, message);
    }

    public static void quiet(Throwable throwable) {
        Log.log(Level.QUIET, throwable);
    }

    public static void quiet(Object message, Throwable throwable) {
        Log.log(Level.QUIET, message, throwable);
    }

    public static void info(Object message) {
        Log.log(Level.INFO, message);
    }

    public static void info(Throwable throwable) {
        Log.log(Level.INFO, throwable);
    }

    public static void info(Object message, Throwable throwable) {
        Log.log(Level.INFO, message, throwable);
    }

    public static void warn(Object message) {
        Log.log(Level.WARN, message);
    }

    public static void warn(Throwable throwable) {
        Log.log(Level.WARN, throwable);
    }

    public static void warn(Object message, Throwable throwable) {
        Log.log(Level.WARN, message, throwable);
    }

    public static void error(Object message) {
        Log.log(Level.ERROR, message);
    }

    public static void error(Throwable throwable) {
        Log.log(Level.ERROR, throwable);
    }

    public static void error(Object message, Throwable throwable) {
        Log.log(Level.ERROR, message, throwable);
    }

    public static void fatal(Object message) {
        Log.log(Level.FATAL, message);
    }

    public static void fatal(Throwable throwable) {
        Log.log(Level.FATAL, throwable);
    }

    public static void fatal(Object message, Throwable throwable) {
        Log.log(Level.FATAL, message, throwable);
    }

    private Log() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        DEBUG,
        QUIET,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

