/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.util.logging;

import java.io.PrintStream;
import net.minecraftforge.util.logging.DelegatePrintStream;
import net.minecraftforge.util.logging.EmptyPrintStream;

public final class Log {
    public static Level enabled = Level.INFO;
    public static final PrintStream DEBUG = new DelegatePrintStream(Level.DEBUG, System.out);
    public static final PrintStream QUIET = new DelegatePrintStream(Level.QUIET, System.out);
    public static final PrintStream INFO = new DelegatePrintStream(Level.INFO, System.out);
    public static final PrintStream WARN = new DelegatePrintStream(Level.WARN, System.out);
    public static final PrintStream ERROR = new DelegatePrintStream(Level.ERROR, System.err);
    public static final PrintStream FATAL = System.err;
    private static byte indent = 0;

    public static void push() {
        indent = (byte)(indent + 1);
    }

    public static void pop() {
        if ((indent = (byte)(indent - 1)) < 0) {
            throw new IllegalArgumentException("Cannot pop logger below 0");
        }
    }

    public static PrintStream getLog(Level level) {
        return level != null ? level.logger : EmptyPrintStream.INSTANCE;
    }

    public static void log(Level level, String message) {
        PrintStream out = Log.getLog(level);
        if (indent != 0) {
            StringBuilder builder = new StringBuilder(message);
            for (int i = 0; i < indent; ++i) {
                builder.insert(0, "  ");
            }
            message = builder.toString();
        }
        out.println(message);
    }

    public static void debug(String message) {
        Log.log(Level.DEBUG, message);
    }

    public static void quiet(String message) {
        Log.log(Level.QUIET, message);
    }

    public static void info(String message) {
        Log.log(Level.INFO, message);
    }

    public static void warn(String message) {
        Log.log(Level.WARN, message);
    }

    public static void error(String message) {
        Log.log(Level.ERROR, message);
    }

    public static void fatal(String message) {
        Log.log(Level.FATAL, message);
    }

    private Log() {
    }

    public static enum Level {
        DEBUG(DEBUG),
        QUIET(QUIET),
        INFO(INFO),
        WARN(WARN),
        ERROR(ERROR),
        FATAL(FATAL);

        public final PrintStream logger;

        private Level(PrintStream logger) {
            this.logger = logger;
        }
    }
}

