/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.util.logging;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.function.Consumer;
import net.minecraftforge.util.logging.Util;
import org.jetbrains.annotations.Nullable;

public interface SimpleLogger {
    public static SimpleLogger getGlobal() {
        return Util.global;
    }

    public static void setGlobal(SimpleLogger logger) {
        Util.global = logger;
    }

    public void push();

    public void pop();

    public int getIndent();

    public void log(Level var1, String var2);

    default public void log(Level level, Consumer<? super PrintStream> message) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        message.accept(new PrintStream(os));
        this.log(level, os.toString());
    }

    default public void trace(String message) {
        this.log(Level.TRACE, message);
    }

    default public void trace(Consumer<? super PrintStream> message) {
        this.log(Level.TRACE, message);
    }

    default public void debug(String message) {
        this.log(Level.DEBUG, message);
    }

    default public void debug(Consumer<? super PrintStream> message) {
        this.log(Level.DEBUG, message);
    }

    default public void quiet(String message) {
        this.log(Level.QUIET, message);
    }

    default public void quiet(Consumer<? super PrintStream> message) {
        this.log(Level.QUIET, message);
    }

    default public void info(String message) {
        this.log(Level.INFO, message);
    }

    default public void info(Consumer<? super PrintStream> message) {
        this.log(Level.INFO, message);
    }

    default public void warn(String message) {
        this.log(Level.WARN, message);
    }

    default public void warn(Consumer<? super PrintStream> message) {
        this.log(Level.WARN, message);
    }

    default public void error(String message) {
        this.log(Level.ERROR, message);
    }

    default public void error(Consumer<? super PrintStream> message) {
        this.log(Level.ERROR, message);
    }

    default public void fatal(String message) {
        this.log(Level.FATAL, message);
    }

    default public void fatal(Consumer<? super PrintStream> message) {
        this.log(Level.FATAL, message);
    }

    public static final class SysOut
    extends Consuming {
        private final boolean debug;
        private final boolean verbose;

        public SysOut() {
            this(false, false);
        }

        public SysOut(boolean debug, boolean verbose) {
            this.debug = debug;
            this.verbose = verbose;
        }

        @Override
        @Nullable
        protected Consumer<String> getOut(Level level) {
            if (!(this.debug || level != Level.TRACE && level != Level.DEBUG)) {
                return null;
            }
            if (!this.verbose && level == Level.QUIET) {
                return null;
            }
            if (level == Level.INFO) {
                return System.out::println;
            }
            return System.err::println;
        }
    }

    public static abstract class Consuming
    implements SimpleLogger {
        private byte indent;

        @Override
        public void push() {
            this.indent = (byte)(this.indent + 1);
        }

        @Override
        public void pop() {
            this.indent = (byte)(this.indent - 1);
            if (this.indent < 0) {
                throw new IllegalArgumentException("Cannot pop logger below 0");
            }
        }

        @Override
        public int getIndent() {
            return this.indent;
        }

        @Nullable
        protected abstract Consumer<String> getOut(Level var1);

        @Override
        public void log(Level level, String message) {
            Consumer<String> out = this.getOut(level);
            if (out == null) {
                return;
            }
            if (this.indent != 0) {
                StringBuilder builder = new StringBuilder(message);
                for (int i = 0; i < this.indent; ++i) {
                    builder.insert(0, "  ");
                }
                message = builder.toString();
            }
            out.accept(message);
        }
    }

    public static enum Level {
        TRACE,
        DEBUG,
        QUIET,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

