/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.util.data.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraftforge.util.data.json.LauncherManifest;
import net.minecraftforge.util.data.json.MinecraftVersion;

public class JsonData {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static LauncherManifest launcherManifest(File file) {
        return JsonData.fromJson(file, LauncherManifest.class);
    }

    public static LauncherManifest launcherManifest(InputStream stream) {
        return JsonData.fromJson(stream, LauncherManifest.class);
    }

    public static LauncherManifest launcherManifest(byte[] data) {
        return JsonData.fromJson(data, LauncherManifest.class);
    }

    public static MinecraftVersion minecraftVersion(File file) {
        return JsonData.fromJson(file, MinecraftVersion.class);
    }

    public static MinecraftVersion minecraftVersion(InputStream stream) {
        return JsonData.fromJson(stream, MinecraftVersion.class);
    }

    public static MinecraftVersion minecraftVersion(byte[] data) {
        return JsonData.fromJson(data, MinecraftVersion.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T fromJson(File file, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        try (FileInputStream stream = new FileInputStream(file);){
            T t = JsonData.fromJson(stream, classOfT);
            return t;
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    private static <T> T fromJson(byte[] data, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return JsonData.fromJson(new ByteArrayInputStream(data), classOfT);
    }

    private static <T> T fromJson(InputStream stream, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return (T)GSON.fromJson((Reader)new InputStreamReader(stream), classOfT);
    }

    private static <T> T fromJson(String data, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return (T)GSON.fromJson(data, classOfT);
    }

    public static String toJson(Object src) {
        return GSON.toJson(src);
    }

    public static void toJson(Object src, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(src, (Appendable)writer);
        }
    }
}

