/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.util.data;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public enum OS {
    AIX("aix"),
    ALPINE("apline_linux", "alpine"),
    LINUX("linux", "unix"),
    MUSL("linux_musl", "musl"),
    MACOS("macos", "mac", "osx", "darwin"),
    QNX("qnx"),
    SOLARIS("solaris", "sunos"),
    WINDOWS("windows", "win"),
    UNKNOWN("unknown");

    private static final OS[] $values;
    public static final OS CURRENT;
    private final String key;
    private final String[] names;

    private OS(String ... names) {
        this.key = names[0];
        this.names = names;
    }

    public String key() {
        return this.key;
    }

    @Nullable
    public static OS byKey(String key) {
        for (OS value : $values) {
            if (!value.key.equals(key)) continue;
            return value;
        }
        return null;
    }

    @Nullable
    public static OS byName(String name) {
        for (OS value : $values) {
            for (String n : value.names) {
                if (!n.equals(name)) continue;
                return value;
            }
        }
        return null;
    }

    public String exe() {
        return this == WINDOWS ? ".exe" : "";
    }

    private static OS getCurrent() {
        String prop = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        for (OS os : $values) {
            for (String key : os.names) {
                if (!prop.contains(key)) continue;
                return os == LINUX ? OS.getCurrentLinux() : os;
            }
        }
        return UNKNOWN;
    }

    private static OS getCurrentLinux() {
        try {
            for (String line : Files.readAllLines(Paths.get("/etc/os-release", new String[0]), StandardCharsets.UTF_8)) {
                if (!(line = line.toLowerCase(Locale.ENGLISH)).startsWith("name=") || !line.contains("alpine")) continue;
                return ALPINE;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return LINUX;
    }

    static {
        $values = OS.values();
        CURRENT = OS.getCurrent();
    }
}

