/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.java_provisioner;

import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.util.EnumConverter;
import net.minecraftforge.java_provisioner.Disco;
import net.minecraftforge.java_provisioner.util.OS;
import net.minecraftforge.java_provisioner.util.ProcessUtils;
import net.minecraftforge.util.logging.Log;

public class DiscoMain {
    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        OptionSpecBuilder helpO = parser.accepts("help", "Displays this help message and exits");
        parser.accepts("disco-main", "Use the DiscoMain entry point");
        ArgumentAcceptingOptionSpec cacheO = parser.accepts("cache", "Directory to store data needed for this program").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("cache"), (Object[])new File[0]);
        OptionSpecBuilder downloadJdkO = parser.accepts("download-jdk", "Download an extracts a JDK");
        ArgumentAcceptingOptionSpec javeVersionO = parser.accepts("java-version", "Major version of java to download, will attempt the highest version avalible if unspecified").withOptionalArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec archO = parser.acceptsAll(DiscoMain.l("arch", "architecture"), "Architecture for use in Disco api").withRequiredArg().withValuesConvertedBy(DiscoMain.converter(Disco.Arch.class)).defaultsTo((Object)Disco.Arch.CURRENT, (Object[])new Disco.Arch[0]);
        ArgumentAcceptingOptionSpec osO = parser.acceptsAll(DiscoMain.l("os", "operating-system"), "Operating System for use in Disco api").withRequiredArg().withValuesConvertedBy(DiscoMain.converter(OS.class)).defaultsTo((Object)OS.CURRENT, (Object[])new OS[0]);
        ArgumentAcceptingOptionSpec distroO = parser.acceptsAll(DiscoMain.l("distro", "distribution"), "Distribution for use in Disco api").withRequiredArg().withValuesConvertedBy(DiscoMain.converter(Disco.Distro.class)).defaultsTo((Object)Disco.Distro.TEMURIN, (Object[])new Disco.Distro[0]);
        OptionSpecBuilder autoO = parser.accepts("auto", "Auto select a JDK to download without prompting if there are multiple options");
        OptionSet options = parser.parse(args);
        File cache = (File)cacheO.value(options);
        boolean success = true;
        if (options.has((OptionSpec)helpO)) {
            parser.printHelpOn((OutputStream)Log.INFO);
        } else if (options.has((OptionSpec)downloadJdkO)) {
            success = DiscoMain.downloadJdk(options.hasArgument((OptionSpec)javeVersionO) ? (Integer)javeVersionO.value(options) : -1, (Disco.Arch)((Object)archO.value(options)), (OS)((Object)osO.value(options)), (Disco.Distro)distroO.value(options), options.has((OptionSpec)autoO), cache);
        } else {
            parser.printHelpOn((OutputStream)Log.INFO);
        }
        if (!success) {
            System.exit(1);
        }
    }

    private static List<String> l(String ... strings) {
        return Arrays.asList(strings);
    }

    private static boolean downloadJdk(int javaVersion, Disco.Arch arch, OS os, Disco.Distro distro, boolean auto, File cache) {
        if (arch == Disco.Arch.UNKNOWN) {
            arch = Disco.Arch.X64;
            Log.warn((Object)("Unknown Architecture (" + System.getProperty("os.arch") + ") Defaulting to " + arch.name() + ". Use --arch to specify an alternative."));
        }
        if (os == OS.UNKNOWN) {
            os = OS.LINUX;
            Log.warn((Object)("Unknown Operating System (" + System.getProperty("os.name") + ") Defaulting to " + os.name() + ". Use --os to specify an alternative."));
        }
        Log.info((Object)"Downloading JDK:");
        Log.info((Object)("    Version: " + (javaVersion == -1 ? "latest" : Integer.valueOf(javaVersion))));
        Log.info((Object)("    Arch:    " + (arch == null ? "null" : arch.name())));
        Log.info((Object)("    OS:      " + (os == null ? "null" : os.name())));
        Log.info((Object)("    Distro:  " + (distro == null ? "null" : distro.name())));
        Log.info((Object)("    Cache:   " + cache.getAbsolutePath()));
        Disco disco = new Disco(new File(cache, "jdks"));
        List<Disco.Package> jdks = disco.getPackages(javaVersion, os, distro, arch);
        Disco.Package pkg = null;
        if (jdks == null || jdks.isEmpty()) {
            Log.error((Object)"Failed to find any download, try specifying a different java version or distro");
            return false;
        }
        if (jdks.size() == 1 || auto) {
            pkg = jdks.get(0);
        } else if (jdks.size() > 1) {
            for (int x = 0; x < jdks.size(); ++x) {
                Disco.Package jdk = jdks.get(x);
                Log.info((Object)String.format("[%2d] %s: %s", x + 1, jdk.distribution, jdk.filename));
            }
            Scanner scan = new Scanner(System.in);
            System.out.print("Select Download: ");
            String line = scan.nextLine();
            int selected = -1;
            try {
                selected = Integer.parseInt(line);
            }
            catch (NumberFormatException e) {
                Log.error((Object)("Invalid selection \"" + line + "\" is not a number."));
            }
            if (selected <= 0 || selected > jdks.size()) {
                Log.error((Object)("Invalid selection, must be between 1 and " + jdks.size()));
                return false;
            }
            pkg = jdks.get(selected - 1);
        }
        Log.info();
        File java_home = disco.extract(pkg);
        if (java_home == null) {
            System.exit(1);
        }
        ProcessUtils.ProbeResult result = ProcessUtils.testJdk(java_home);
        if (result.exitCode != 0) {
            Log.error((Object)"Failed to run extracted java:");
            for (String line : result.lines) {
                Log.error((Object)line);
            }
            return false;
        }
        return true;
    }

    private static <T extends Enum<T>> EnumConverter<T> converter(Class<T> clazz) {
        return new EnumConverter<T>(clazz){

            public T convert(String value) {
                if ("null".equals(value)) {
                    return null;
                }
                return super.convert(value);
            }
        };
    }
}

