/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.java_provisioner.shadow.org.kamranzafar.jtar;

public class Octal {
    public static long parseOctal(byte[] header, int offset, int length) {
        long result = 0L;
        boolean stillPadding = true;
        int end = offset + length;
        for (int i = offset; i < end && header[i] != 0; ++i) {
            if (header[i] == 32 || header[i] == 48) {
                if (stillPadding) continue;
                if (header[i] == 32) break;
            }
            stillPadding = false;
            result = (result << 3) + (long)(header[i] - 48);
        }
        return result;
    }

    public static int getOctalBytes(long value, byte[] buf, int offset, int length) {
        int idx = length - 1;
        buf[offset + idx] = 0;
        buf[offset + --idx] = 32;
        --idx;
        if (value == 0L) {
            buf[offset + idx] = 48;
            --idx;
        } else {
            for (long val = value; idx >= 0 && val > 0L; val >>= 3, --idx) {
                buf[offset + idx] = (byte)(48 + (byte)(val & 7L));
            }
        }
        while (idx >= 0) {
            buf[offset + idx] = 32;
            --idx;
        }
        return offset + length;
    }

    public static int getCheckSumOctalBytes(long value, byte[] buf, int offset, int length) {
        Octal.getOctalBytes(value, buf, offset, length);
        buf[offset + length - 1] = 32;
        buf[offset + length - 2] = 0;
        return offset + length;
    }

    public static int getLongOctalBytes(long value, byte[] buf, int offset, int length) {
        byte[] temp = new byte[length + 1];
        Octal.getOctalBytes(value, temp, 0, length + 1);
        System.arraycopy(temp, 0, buf, offset, length);
        return offset + length;
    }
}

