/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.java_provisioner;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.java_provisioner.Disco;
import net.minecraftforge.java_provisioner.DiscoLocator;
import net.minecraftforge.java_provisioner.DiscoMain;
import net.minecraftforge.java_provisioner.GradleLocator;
import net.minecraftforge.java_provisioner.JavaHomeLocator;
import net.minecraftforge.java_provisioner.api.IJavaInstall;
import net.minecraftforge.java_provisioner.api.IJavaLocator;
import net.minecraftforge.java_provisioner.util.OS;
import net.minecraftforge.util.logging.Log;

public class Main {
    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        if (Main.hasArgument(args, "--disco-main")) {
            DiscoMain.main(args);
            return;
        }
        OptionSpecBuilder helpO = parser.accepts("help", "Displays this help message and exits");
        parser.accepts("disco-main", "Use the DiscoMain entry point");
        ArgumentAcceptingOptionSpec cacheO = parser.accepts("cache", "Directory to store data needed for this program").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("cache"), (Object[])new File[0]);
        OptionSpecBuilder offlineO = parser.accepts("offline", "Do not attempt to download any JDKs, only use the cache");
        ArgumentAcceptingOptionSpec versionO = parser.accepts("version", "Major version of java to try and locate").withRequiredArg().ofType(Integer.class);
        OptionSpecBuilder allO = parser.accepts("all", "Display information about all detected java installs");
        OptionSpecBuilder testO = parser.accepts("test", "Enable test functionality, provisioning a bunch of jdks.");
        OptionSet options = parser.parse(args);
        if (options.has((OptionSpec)helpO)) {
            parser.printHelpOn((OutputStream)Log.INFO);
            return;
        }
        File cache = (File)options.valueOf((OptionSpec)cacheO);
        DiscoLocator disco = new DiscoLocator(cache, options.has((OptionSpec)offlineO));
        ArrayList<IJavaLocator> locators = new ArrayList<IJavaLocator>();
        locators.add(new JavaHomeLocator());
        locators.add(new GradleLocator());
        locators.add(disco);
        if (options.has((OptionSpec)testO)) {
            Disco tmp = new Disco(cache);
            int version = options.has((OptionSpec)versionO) ? (Integer)options.valueOf((OptionSpec)versionO) : 22;
            for (Disco.Distro dist : new Disco.Distro[]{Disco.Distro.TEMURIN, Disco.Distro.AOJ, Disco.Distro.ORACLE, Disco.Distro.ZULU, Disco.Distro.GRAALVM, Disco.Distro.GRAALVM_COMMUNITY}) {
                List<Disco.Package> jdks = tmp.getPackages(version, OS.CURRENT, dist, Disco.Arch.CURRENT);
                int seen = 0;
                for (Disco.Package pkg : jdks) {
                    if (seen++ >= 3) continue;
                    tmp.extract(pkg);
                }
            }
        }
        if (options.has((OptionSpec)allO)) {
            Main.listAllJavaInstalls(locators);
        } else if (options.has((OptionSpec)versionO)) {
            int version = (Integer)options.valueOf((OptionSpec)versionO);
            Main.findSpecificVersion(locators, disco, version);
        } else {
            Log.error((Object)"You must specify a version to search for using --version or --all to list all java installs.");
            parser.printHelpOn((OutputStream)Log.INFO);
            System.exit(-1);
        }
    }

    private static boolean hasArgument(String[] args, String arg) {
        for (String s : args) {
            if (!s.toLowerCase(Locale.ENGLISH).startsWith(arg)) continue;
            return true;
        }
        return false;
    }

    private static void findSpecificVersion(List<IJavaLocator> locators, DiscoLocator disco, int version) {
        IJavaInstall probe;
        IJavaLocator locator2;
        File result = null;
        Iterator<IJavaLocator> iterator = locators.iterator();
        while (iterator.hasNext() && (result = (locator2 = iterator.next()).find(version)) == null) {
        }
        if (result == null && (probe = disco.provision(version)) != null) {
            result = probe.home();
        }
        if (result != null && result.exists()) {
            String home = result.getAbsolutePath();
            if (!home.endsWith(File.separator)) {
                home = home + File.separatorChar;
            }
            Log.info((Object)home);
        } else {
            Log.error((Object)("Failed to find sutable java for version " + version));
            for (IJavaLocator locator2 : locators) {
                Log.error((Object)("Locator: " + locator2.getClass().getSimpleName()));
                for (String line : locator2.logOutput()) {
                    Log.error((Object)("  " + line));
                }
            }
            System.exit(1);
        }
    }

    private static void listAllJavaInstalls(List<IJavaLocator> locators) {
        ArrayList<IJavaInstall> installs = new ArrayList<IJavaInstall>();
        for (IJavaLocator locator : locators) {
            List<IJavaInstall> found = locator.findAll();
            installs.addAll(found);
        }
        HashSet<File> seen = new HashSet<File>();
        Iterator itr = installs.iterator();
        while (itr.hasNext()) {
            IJavaInstall install = (IJavaInstall)itr.next();
            if (seen.add(install.home())) continue;
            itr.remove();
        }
        Collections.sort(installs);
        for (IJavaInstall install : installs) {
            Log.info((Object)install.home().getAbsolutePath());
            Log.info((Object)("  Vendor:  " + install.vendor()));
            Log.info((Object)("  Type:    " + (install.isJdk() ? "JDK" : "JRE")));
            Log.info((Object)("  Version: " + install.version()));
        }
    }
}

