/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.java_provisioner.shadow.net.minecraftforge.util.logging;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.function.Consumer;
import net.minecraftforge.java_provisioner.shadow.net.minecraftforge.util.logging.Log;
import net.minecraftforge.java_provisioner.shadow.net.minecraftforge.util.logging.LogConsumer;

final class CapturingPrintStream
extends OutputStream {
    private final Consumer<String> logger;
    private StringBuffer buffer;

    static PrintStream of(Log.Level level, Consumer<String> logger) {
        return new PrintStream(new CapturingPrintStream(new LogConsumer(level, logger)));
    }

    private CapturingPrintStream(Consumer<String> logger) {
        this.logger = logger;
        this.reset();
    }

    private void reset() {
        this.buffer = new StringBuffer(512);
    }

    @Override
    public void write(int b) {
        this.write((char)b);
    }

    private void write(char c) {
        if (c == '\n' || c == '\r') {
            if (this.buffer.length() != 0) {
                this.logger.accept(this.buffer.insert(0, Log.getIndentation()).toString());
                this.reset();
            }
        } else {
            this.buffer.append(c);
        }
    }
}

