/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.java_provisioner.shadow.joptsimple.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import net.minecraftforge.java_provisioner.shadow.joptsimple.ValueConversionException;
import net.minecraftforge.java_provisioner.shadow.joptsimple.ValueConverter;
import net.minecraftforge.java_provisioner.shadow.joptsimple.internal.Messages;

public class InetAddressConverter
implements ValueConverter<InetAddress> {
    @Override
    public InetAddress convert(String value) {
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            throw new ValueConversionException(this.message(value));
        }
    }

    @Override
    public String revert(Object value) {
        return this.valueType().cast(value).getHostName();
    }

    @Override
    public Class<InetAddress> valueType() {
        return InetAddress.class;
    }

    @Override
    public String valuePattern() {
        return null;
    }

    private String message(String value) {
        return Messages.message(Locale.getDefault(), "net.minecraftforge.java_provisioner.shadow.joptsimple.ExceptionMessages", InetAddressConverter.class, "message", value);
    }
}

