/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.gradle;

import javax.inject.Inject;
import net.minecraftforge.jarjar.gradle.JarJar;
import net.minecraftforge.jarjar.gradle.JarJarContainerInternal;
import net.minecraftforge.jarjar.gradle.JarJarProblems;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyScopeConfiguration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolvableConfiguration;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponentFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.tasks.Jar;
import org.gradle.jvm.toolchain.JavaLanguageVersion;

abstract class JarJarContainerImpl
implements JarJarContainerInternal {
    private final String name;
    private final Project project;
    private final TaskProvider<? extends Jar> jar;
    private final TaskProvider<JarJar> task;
    private final NamedDomainObjectProvider<DependencyScopeConfiguration> configuration;
    private final NamedDomainObjectProvider<ResolvableConfiguration> resolvableConfiguration;
    private final AdhocComponentWithVariants softwareComponent;
    private final JarJarProblems problems = (JarJarProblems)this.getObjects().newInstance(JarJarProblems.class, new Object[0]);

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract SoftwareComponentFactory getSoftwareComponents();

    @Inject
    public JarJarContainerImpl(String name, Project project, TaskProvider<? extends Jar> jar, Action<? super JarJar> taskAction) {
        this.name = name;
        this.project = project;
        this.jar = jar;
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        ConfigurationContainer configurations = project.getConfigurations();
        try {
            this.configuration = configurations.dependencyScope(this.getConfigurationName(), c -> c.setDescription("The default configuration to be used for Forge Jar-in-Jar's output."));
            this.resolvableConfiguration = configurations.resolvable(this.getResolvableConfigurationName(), c -> {
                c.setDescription("The default resolvable configuration to be used in Forge Jar-in-Jar's output.");
                c.extendsFrom(new Configuration[]{(Configuration)this.configuration.get()});
            });
        }
        catch (InvalidUserDataException e) {
            throw this.problems.configurationAlreadyExists(e);
        }
        this.task = JarJar.register(this, taskAction);
        this.softwareComponent = this.getSoftwareComponents().adhoc(this.getSoftwareComponentName());
        project.getComponents().add((Object)this.softwareComponent);
        NamedDomainObjectProvider runtimeClasspath = configurations.named("runtimeClasspath");
        NamedDomainObjectProvider jarJarRuntimeDependencies = configurations.dependencyScope(this.getConsumableDependenciesConfigurationName(), configuration -> configuration.withDependencies(dependencies -> {
            DependencySet included = ((ResolvableConfiguration)this.resolvableConfiguration.get()).getAllDependencies();
            for (Dependency dependency : ((Configuration)runtimeClasspath.get()).getAllDependencies()) {
                if (included.contains((Object)dependency)) continue;
                dependencies.add((Object)dependency);
            }
        }));
        NamedDomainObjectProvider jarJarRuntimeElements = configurations.consumable(this.getConsumableConfigurationName(), configuration -> {
            configuration.attributes(attributes -> {
                attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.getObjects().named(Usage.class, "java-runtime")));
                attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.getObjects().named(Category.class, "library")));
                attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.getObjects().named(LibraryElements.class, "jar")));
                attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)this.getObjects().named(Bundling.class, "shadowed")));
                attributes.attributeProvider(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, configurations.named("compileClasspath").map(c -> (Integer)c.getAttributes().getAttribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE)).orElse(this.getProviders().provider(() -> java.getTargetCompatibility().getMajorVersion()).map(JavaLanguageVersion::of).map(JavaLanguageVersion::asInt)));
            });
            configuration.outgoing(outgoing -> outgoing.artifact(this.task));
            configuration.extendsFrom(new Configuration[]{(Configuration)jarJarRuntimeDependencies.get()});
            project.getComponents().named("java", AdhocComponentWithVariants.class, component -> component.addVariantsFromConfiguration((Configuration)configuration, variant -> {
                variant.getConfigurationVariant().getDescription().set((Object)"Dependencies embedded using Forge Jar-in-Jar.");
                variant.mapToMavenScope("runtime");
            }));
            this.softwareComponent.addVariantsFromConfiguration((Configuration)configuration, variant -> {
                variant.getConfigurationVariant().getDescription().set((Object)"Dependencies embedded using Forge Jar-in-Jar.");
                variant.mapToMavenScope("runtime");
            });
        });
        project.afterEvaluate(this::finish);
    }

    private void finish(Project project) {
        DependencyScopeConfiguration jarJarConfiguration = (DependencyScopeConfiguration)this.configuration.get();
        if (jarJarConfiguration.getDependencies().size() != jarJarConfiguration.getAllDependencies().size()) {
            this.problems.reportConfigurationWithTransitiveDependencies();
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public TaskProvider<? extends Jar> getJar() {
        return this.jar;
    }

    @Override
    public NamedDomainObjectProvider<DependencyScopeConfiguration> getConfiguration() {
        return this.configuration;
    }

    @Override
    public NamedDomainObjectProvider<ResolvableConfiguration> getResolvableConfiguration() {
        return this.resolvableConfiguration;
    }

    @Override
    public AdhocComponentWithVariants getSoftwareComponent() {
        return this.softwareComponent;
    }
}

