/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.gradle;

import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import net.minecraftforge.jarjar.gradle.JarJarDependencyMethods;
import net.minecraftforge.jarjar.gradle.JarJarMetadataInfoInternal;
import net.minecraftforge.jarjar.gradle.JarJarProblems;
import net.minecraftforge.jarjar.gradle.Util;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;

final class ResolvedDependencyInfo
implements Serializable {
    private static final long serialVersionUID = -7577318115877822993L;
    final ModuleVersionIdentifier module;
    final String version;
    final String versionRange;
    final boolean hasManuallySpecifiedRange;
    final File artifact;
    final String asString;

    @Inject
    public ResolvedDependencyInfo(ModuleVersionIdentifier module, String version, String versionRange, boolean hasManuallySpecifiedRange, File artifact, String asString) {
        this.module = module;
        this.version = version;
        this.versionRange = versionRange;
        this.hasManuallySpecifiedRange = hasManuallySpecifiedRange;
        this.artifact = artifact;
        this.asString = asString;
    }

    static Set<File> getFiles(Set<ResolvedDependencyInfo> resolvedDependencies) {
        HashSet<File> ret = new HashSet<File>(resolvedDependencies.size());
        for (ResolvedDependencyInfo dependency : resolvedDependencies) {
            ret.add(dependency.artifact);
        }
        return ret;
    }

    static Set<ResolvedDependencyInfo> from(JarJarProblems problems, ConfigurationContainer configurations, Configuration configuration) {
        DependencySet dependencies = configuration.getAllDependencies();
        if (dependencies.isEmpty()) {
            return Set.of();
        }
        HashSet<ResolvedDependencyInfo> ret = new HashSet<ResolvedDependencyInfo>(dependencies.size());
        for (Dependency dependency : dependencies) {
            JarJarMetadataInfoInternal jarJar = (JarJarMetadataInfoInternal)JarJarDependencyMethods.getJarJar(dependency);
            String group = jarJar.getGroup();
            String name = jarJar.getName();
            String version = jarJar.getVersion();
            String versionRange = jarJar.getRange();
            boolean hasManuallySpecifiedRange = jarJar.hasManuallySpecifiedRange();
            if (dependency instanceof FileCollectionDependency) {
                FileCollectionDependency filesDependency = (FileCollectionDependency)dependency;
                File artifact = filesDependency.getFiles().getSingleFile();
                ret.add(new ResolvedDependencyInfo(new MinimalModuleVersionIdentifier(group, name, version), version, versionRange, hasManuallySpecifiedRange, artifact, Util.toString((Dependency)filesDependency)));
                continue;
            }
            if (dependency instanceof ModuleDependency) {
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                if ((moduleDependency = moduleDependency.copy()) instanceof ExternalModuleDependency) {
                    ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)moduleDependency;
                    externalModuleDependency.version(v -> v.strictly(version.toString()));
                }
                Configuration detachedConfiguration = configurations.detachedConfiguration(new Dependency[]{moduleDependency});
                detachedConfiguration.setTransitive(false);
                boolean hasInfo = false;
                for (ResolvedArtifact artifact : ((ResolvedDependency)detachedConfiguration.getResolvedConfiguration().getFirstLevelModuleDependencies().iterator().next()).getModuleArtifacts()) {
                    String fileName = ResolvedDependencyInfo.getFileName(artifact);
                    if (!fileName.endsWith(".jar")) continue;
                    if (hasInfo) {
                        throw problems.moduleHasTooManyJarArtifacts(moduleDependency, artifact);
                    }
                    ret.add(new ResolvedDependencyInfo(new MinimalModuleVersionIdentifier(group, name, artifact.getModuleVersion().getId().getVersion()), version, versionRange, hasManuallySpecifiedRange, artifact.getFile(), Util.toString((Dependency)moduleDependency)));
                    hasInfo = true;
                }
                if (hasInfo) continue;
                throw problems.moduleHasNoJarArtifacts(moduleDependency);
            }
            throw problems.dependencyIsNotAModule(dependency);
        }
        return ret;
    }

    private static String getFileName(ResolvedArtifact artifact) {
        try {
            return InvokerHelper.getProperty((Object)artifact.getId(), (String)"fileName").toString();
        }
        catch (Throwable e) {
            return artifact.getFile().getName();
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ResolvedDependencyInfo that = (ResolvedDependencyInfo)obj;
        return Objects.equals(this.module, that.module) && Objects.equals(this.version, that.version) && Objects.equals(this.versionRange, that.versionRange) && Objects.equals(this.artifact, that.artifact);
    }

    public int hashCode() {
        return Objects.hash(this.module, this.version, this.versionRange, this.artifact);
    }

    public String toString() {
        return "ResolvedDependencyInfo[module=" + String.valueOf(this.module) + ", fixedVersion=" + this.version + ", versionRange=" + this.versionRange + ", artifact=" + String.valueOf(this.artifact) + "]";
    }

    static final class MinimalModuleVersionIdentifier
    implements ModuleIdentifier,
    ModuleVersionIdentifier {
        private static final long serialVersionUID = -955346236759069739L;
        private final String group;
        private final String name;
        private final String version;

        @Inject
        public MinimalModuleVersionIdentifier(String group, String name, String version) {
            this.group = group;
            this.name = name;
            this.version = version;
        }

        public ModuleIdentifier getModule() {
            return this;
        }

        public String getGroup() {
            return this.group;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof MinimalModuleVersionIdentifier)) return false;
            MinimalModuleVersionIdentifier o = (MinimalModuleVersionIdentifier)obj;
            if (!Objects.equals(this.group, o.group)) return false;
            if (!Objects.equals(this.name, o.name)) return false;
            if (!Objects.equals(this.version, o.version)) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.group, this.name, this.version);
        }

        public String toString() {
            return "MinimalModuleVersionIdentifier[group=" + this.group + ", name=" + this.name + ", version=" + this.version + "]";
        }
    }
}

