/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.gradle;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import net.minecraftforge.jarjar.gradle.JarJarProblems;
import net.minecraftforge.jarjar.gradle.JarJarTask;
import net.minecraftforge.jarjar.gradle.ResolvedDependencyInfo;
import net.minecraftforge.jarjar.gradle.Tools;
import net.minecraftforge.jarjar.metadata.ContainedJarIdentifier;
import net.minecraftforge.jarjar.metadata.ContainedJarMetadata;
import net.minecraftforge.jarjar.metadata.ContainedVersion;
import net.minecraftforge.jarjar.metadata.Metadata;
import net.minecraftforge.jarjar.metadata.MetadataIOHandler;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

abstract class JarJarMetadata
extends DefaultTask
implements JarJarTask {
    @Input
    protected abstract SetProperty<ResolvedDependencyInfo> getResolvedDependencies();

    @OutputFile
    protected abstract RegularFileProperty getMetadataFile();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @InputFiles
    @Classpath
    protected abstract ConfigurableFileCollection getWorkerClasspath();

    @Inject
    public JarJarMetadata() {
        this.getMetadataFile().convention(this.getDefaultOutputDirectory().map(d -> d.file("metadata.json")));
        this.getWorkerClasspath().setFrom(new Object[]{this.getTool(Tools.JARJAR_LEGACY_METADATA)});
    }

    @TaskAction
    protected void exec() {
        WorkQueue work = this.getWorkerExecutor().classLoaderIsolation(spec -> spec.getClasspath().from(new Object[]{this.getWorkerClasspath()}));
        work.submit(Action.class, parameters -> {
            parameters.getResolvedDependencies().set(this.getResolvedDependencies());
            parameters.getMetadataFile().set((Provider)this.getMetadataFile());
        });
        work.await();
    }

    static abstract class Action
    implements WorkAction<Parameters> {
        private final JarJarProblems problems = (JarJarProblems)this.getObjects().newInstance(JarJarProblems.class, new Object[0]);

        @Inject
        protected abstract ObjectFactory getObjects();

        @Inject
        public Action() {
        }

        public void execute() {
            Parameters parameters = (Parameters)this.getParameters();
            Set resolved = (Set)parameters.getResolvedDependencies().get();
            ArrayList<ContainedJarMetadata> jars = new ArrayList<ContainedJarMetadata>(resolved.size());
            for (ResolvedDependencyInfo dependency : resolved) {
                jars.add(new ContainedJarMetadata(new ContainedJarIdentifier(this.validateGroup(dependency), dependency.module.getName()), new ContainedVersion(this.parseVersionRange(dependency), this.parseVersion(dependency)), "META-INF/jarjar/" + dependency.artifact.getName(), false));
            }
            try {
                Files.write(((File)parameters.getMetadataFile().getAsFile().get()).toPath(), (Iterable<? extends CharSequence>)MetadataIOHandler.toLines((Metadata)new Metadata(jars)), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private String validateGroup(ResolvedDependencyInfo dependency) {
            try {
                return Objects.requireNonNull(dependency.module.getGroup());
            }
            catch (NullPointerException e) {
                throw this.problems.dependencyHasUnspecifiedModuleGroup(e, dependency.asString);
            }
        }

        private ArtifactVersion parseVersion(ResolvedDependencyInfo resolved) {
            try {
                return VersionRange.createFromVersionSpec((String)Objects.requireNonNull(resolved.version)).getRecommendedVersion();
            }
            catch (InvalidVersionSpecificationException e) {
                throw this.problems.dependencyHasInvalidVersion((Exception)((Object)e), resolved.asString);
            }
            catch (NullPointerException e) {
                throw this.problems.dependencyHasUnspecifiedVersion(e, resolved.asString);
            }
        }

        private VersionRange parseVersionRange(ResolvedDependencyInfo dependency) {
            if (dependency.hasManuallySpecifiedRange) {
                try {
                    return VersionRange.createFromVersionSpec((String)dependency.versionRange);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw this.problems.dependencyHasInvalidVersionRange((Exception)((Object)e), dependency.asString);
                }
            }
            try {
                return VersionRange.createFromVersionSpec((String)"[%s,)".formatted(Objects.requireNonNull(dependency.versionRange)));
            }
            catch (InvalidVersionSpecificationException e) {
                throw this.problems.dependencyHasInvalidVersionForRange((Exception)((Object)e), dependency.asString);
            }
            catch (NullPointerException e) {
                throw this.problems.dependencyHasUnspecifiedVersionForRange(e, dependency.asString);
            }
        }

        static interface Parameters
        extends WorkParameters {
            public SetProperty<ResolvedDependencyInfo> getResolvedDependencies();

            public RegularFileProperty getMetadataFile();
        }
    }
}

