/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.gradle;

import javax.inject.Inject;
import net.minecraftforge.jarjar.gradle.JarJarContainerInternal;
import net.minecraftforge.jarjar.gradle.JarJarMetadata;
import net.minecraftforge.jarjar.gradle.JarJarProblems;
import net.minecraftforge.jarjar.gradle.JarJarTask;
import net.minecraftforge.jarjar.gradle.ResolvedDependencyInfo;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
@ApiStatus.Experimental
public abstract class JarJar
extends Jar
implements JarJarTask {
    private final CopySpec jarJarCopySpec = this.getMainSpec().addChild().into((Object)"META-INF/jarjar");
    final SetProperty<ResolvedDependencyInfo> resolvedDependencies = this.getObjectFactory().setProperty(ResolvedDependencyInfo.class);
    private final JarJarProblems problems = (JarJarProblems)this.getObjectFactory().newInstance(JarJarProblems.class, new Object[0]);

    static TaskProvider<JarJar> register(JarJarContainerInternal container, Action<? super JarJar> taskAction) {
        Project project = container.getProject();
        TaskProvider<? extends org.gradle.jvm.tasks.Jar> jar = container.getJar();
        TaskContainer tasks = project.getTasks();
        TaskProvider jarJar = tasks.register(jar.getName() + "Jar", JarJar.class, task -> {
            task.setDescription("Combines an assembled jar archive with the resolved Jar-in-Jar dependencies.");
            task.setGroup((String)jar.map(Task::getGroup).getOrElse((Object)"build"));
            task.getArchiveClassifier().set(jar.flatMap(AbstractArchiveTask::getArchiveClassifier).filter(s -> !s.isBlank()).map(s -> s + "-all").orElse((Object)"all"));
            task.dependsOn(new Object[]{jar});
            task.with(new CopySpec[]{(CopySpec)jar.get()});
            task.setConfiguration((Provider<? extends Configuration>)container.getResolvableConfiguration());
            taskAction.execute(task);
        });
        tasks.named("assemble"::equals).configureEach(it -> it.dependsOn(new Object[]{jarJar}));
        project.afterEvaluate(p -> {
            TaskProvider metadata = p.getTasks().register(jarJar.getName() + "Metadata", JarJarMetadata.class, task -> {
                task.setDescription("Generates the Jar-in-Jar metadata to be used by task '%s'".formatted(jarJar.getName()));
                task.getResolvedDependencies().set(((JarJar)jarJar.get()).resolvedDependencies);
            });
            ((JarJar)jarJar.get()).dependsOn(new Object[]{metadata});
            ((JarJar)jarJar.get()).getMetadataFile().set(metadata.flatMap(JarJarMetadata::getMetadataFile));
            ((JarJar)jarJar.get()).setManifest(((org.gradle.jvm.tasks.Jar)jar.get()).getManifest());
        });
        return jarJar;
    }

    @InputFiles
    @Classpath
    @SkipWhenEmpty
    protected abstract ConfigurableFileCollection getIncludedClasspath();

    public void setConfiguration(Configuration configuration) {
        this.resolvedDependencies.set(this.getProviders().provider(() -> configuration).map(c -> ResolvedDependencyInfo.from(this.problems, this.getProject().getConfigurations(), c)));
        this.getIncludedClasspath().setFrom(new Object[]{this.resolvedDependencies.map(ResolvedDependencyInfo::getFiles)});
    }

    public void setConfiguration(Provider<? extends Configuration> configuration) {
        this.setConfiguration((Configuration)configuration.get());
    }

    @InputFile
    public abstract RegularFileProperty getMetadataFile();

    @Inject
    protected abstract ProviderFactory getProviders();

    protected void copy() {
        this.jarJarCopySpec.from(new Object[]{this.getIncludedClasspath()});
        this.jarJarCopySpec.from(new Object[]{this.getMetadataFile()});
        super.copy();
    }
}

