/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.stubify;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.classfile.ClassFile;
import java.lang.classfile.ClassTransform;
import java.lang.classfile.CodeBuilder;
import java.lang.classfile.CodeElement;
import java.lang.classfile.CodeTransform;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.Iterator;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.stubify.shadow.joptsimple.AbstractOptionSpec;
import net.minecraftforge.stubify.shadow.joptsimple.ArgumentAcceptingOptionSpec;
import net.minecraftforge.stubify.shadow.joptsimple.OptionParser;
import net.minecraftforge.stubify.shadow.joptsimple.OptionSet;
import net.minecraftforge.stubify.shadow.joptsimple.OptionSpecBuilder;

public class Main {
    private static final ClassDesc RUNTIME_EXCEPTION = ClassDesc.of(RuntimeException.class.getName());
    private static final Checksum CRC32 = new CRC32();

    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<File> inputO = parser.accepts("input", "Input file").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<File> outputO = parser.accepts("output", "Output file").withRequiredArg().ofType(File.class).required();
        OptionSpecBuilder storeO = parser.accepts("store", "Uses STORED method, disabling compression");
        AbstractOptionSpec helpO = parser.accepts("help").forHelp();
        OptionSet options = parser.parse(args);
        if (options.has(helpO)) {
            parser.printHelpOn(System.out);
            return;
        }
        File input = options.valueOf(inputO);
        File output = options.valueOf(outputO);
        boolean store = options.has(storeO);
        System.out.println("Input:  " + (input == null ? "null" : input.getAbsolutePath()));
        System.out.println("Output: " + (output == null ? "null" : output.getAbsolutePath()));
        System.out.println("Store:  " + store);
        if (!input.exists()) {
            throw new IllegalArgumentException("Input file does not exist: " + String.valueOf(input));
        }
        File parent = output.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdir();
        }
        if (output.exists()) {
            output.delete();
        }
        try (ZipFile zipIn = new ZipFile(input);
             ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(output));){
            if (store) {
                zipOut.setMethod(0);
            }
            Iterator<? extends ZipEntry> itr = zipIn.entries().asIterator();
            while (itr.hasNext()) {
                ZipEntry entry = itr.next();
                if (!entry.getName().endsWith(".class")) continue;
                System.out.println("Processing " + entry.getName());
                byte[] data = zipIn.getInputStream(entry).readAllBytes();
                ClassTransform classTransform = ClassTransform.transformingMethodBodies((CodeTransform)new CodeTransform(){

                    public void accept(CodeBuilder builder, CodeElement element) {
                    }

                    public void atEnd(CodeBuilder builder) {
                        builder.new_(RUNTIME_EXCEPTION).dup().invokespecial(RUNTIME_EXCEPTION, "<init>", ConstantDescs.MTD_void).athrow();
                    }
                });
                ClassFile classFile = ClassFile.of().withOptions(new ClassFile.Option[]{ClassFile.ConstantPoolSharingOption.NEW_POOL});
                byte[] transformed = classFile.transformClass(classFile.parse(data), classTransform);
                ZipEntry next = new ZipEntry(entry.getName());
                next.setTime(entry.getTime());
                if (store) {
                    next.setSize(transformed.length);
                    next.setCompressedSize(transformed.length);
                    next.setCrc(Main.crc32(transformed));
                }
                zipOut.putNextEntry(next);
                zipOut.write(transformed);
                zipOut.closeEntry();
            }
        }
    }

    private static long crc32(byte[] data) {
        CRC32.reset();
        CRC32.update(data);
        return CRC32.getValue();
    }
}

