/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.internal;

import java.io.File;
import java.util.Objects;
import net.minecraftforge.gradleutils.GradleUtilsExtension;
import net.minecraftforge.gradleutils.GradleUtilsExtensionForProject;
import net.minecraftforge.gradleutils.internal.Util;
import org.gradle.api.Action;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.jetbrains.annotations.UnknownNullability;

interface GradleUtilsExtensionInternal
extends GradleUtilsExtension,
HasPublicType {
    public static final Action<MavenArtifactRepository> forgeMaven = repo -> {
        repo.setName("MinecraftForge");
        repo.setUrl((Object)"https://maven.minecraftforge.net/");
    };
    public static final Action<MavenArtifactRepository> forgeReleaseMaven = repo -> {
        repo.setName("MinecraftForge releases");
        repo.setUrl((Object)"https://maven.minecraftforge.net/releases/");
    };
    public static final Action<MavenArtifactRepository> minecraftLibsMaven = repo -> {
        repo.setName("Minecraft libraries");
        repo.setUrl((Object)"https://libraries.minecraft.net/");
    };

    default public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(GradleUtilsExtension.class);
    }

    @Override
    default public Action<MavenArtifactRepository> getForgeMaven() {
        return forgeMaven;
    }

    @Override
    default public Action<MavenArtifactRepository> getForgeReleaseMaven() {
        return forgeReleaseMaven;
    }

    @Override
    default public Action<MavenArtifactRepository> getMinecraftLibsMaven() {
        return minecraftLibsMaven;
    }

    @Override
    default public Action<MavenArtifactRepository> getPublishingForgeMaven() {
        return this.getPublishingForgeMaven("https://maven.minecraftforge.net/releases/");
    }

    @Override
    default public Action<MavenArtifactRepository> getPublishingForgeMaven(File defaultFolder) {
        return this.getPublishingForgeMaven("https://maven.minecraftforge.net/releases/", defaultFolder);
    }

    @Override
    default public Action<MavenArtifactRepository> getPublishingForgeMaven(Directory defaultFolder) {
        return this.getPublishingForgeMaven("https://maven.minecraftforge.net/releases/", defaultFolder);
    }

    @Override
    default public Action<MavenArtifactRepository> getPublishingForgeMaven(Provider<?> defaultFolder) {
        return this.getPublishingForgeMaven("https://maven.minecraftforge.net/releases/", defaultFolder);
    }

    @Override
    default public <T> T unpack(Object value) {
        return Util.unpack(value);
    }

    default public <T> T unpackOrNull(@UnknownNullability Object value) {
        try {
            return this.unpack(Objects.requireNonNull(value));
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static interface ForProject
    extends GradleUtilsExtensionInternal,
    GradleUtilsExtensionForProject,
    HasPublicType {
        @Override
        default public TypeOf<?> getPublicType() {
            return TypeOf.typeOf(GradleUtilsExtensionForProject.class);
        }
    }
}

