/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.shadow.net.minecraftforge.util.download;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.shadow.net.minecraftforge.util.logging.Log;
import org.jetbrains.annotations.Nullable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DownloadUtils {
    private static final Duration TIMEOUT = Duration.ofSeconds(5L);
    private static final int MAX_REDIRECTS = 3;
    private static final HttpClient CLIENT = HttpClient.newBuilder().connectTimeout(TIMEOUT).followRedirects(HttpClient.Redirect.NEVER).build();
    private static final HttpRequest.Builder REQUEST_BUILDER = HttpRequest.newBuilder().timeout(TIMEOUT).header("User-Agent", "MinecraftForge-Utils").header("Accept", "application/json");

    private static InputStream connect(String address) throws IOException, InterruptedException {
        HttpResponse con;
        URI uri;
        try {
            uri = new URI(address);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        String scheme = uri.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("https") && !scheme.equalsIgnoreCase("http")) {
            return uri.toURL().openStream();
        }
        ArrayList<String> redirections = new ArrayList<String>();
        int redirects = 0;
        while (true) {
            String location;
            int res;
            if ((res = (con = CLIENT.send(REQUEST_BUILDER.uri(uri).build(), info -> HttpResponse.BodySubscribers.ofInputStream())).statusCode()) == 301 || res == 302) {
                Optional<String> header = con.headers().firstValue("Location");
                if (header.isEmpty()) {
                    throw new IOException(String.format("No location header found in redirect response: %s -- previous redirections: [%s]", uri, String.join((CharSequence)", ", redirections)));
                }
                location = header.get();
                redirections.add(location);
                if (redirects == 2) {
                    throw new IOException(String.format("Too many redirects: %s -- redirections: [%s]", address, String.join((CharSequence)", ", redirections)));
                }
            } else {
                if (res != 404) break;
                throw new FileNotFoundException("Returned 404: " + address);
            }
            Log.debug("Following redirect: " + location);
            uri = uri.resolve(location);
            ++redirects;
        }
        return (InputStream)con.body();
    }

    public static String downloadString(String url) throws IOException {
        String string;
        block8: {
            InputStream stream = DownloadUtils.connect(url);
            try {
                string = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DownloadFailedException(url, e);
                }
            }
            stream.close();
        }
        return string;
    }

    @Nullable
    public static String tryDownloadString(boolean silent, String url) {
        try {
            return DownloadUtils.downloadString(url);
        }
        catch (IOException e) {
            if (!silent) {
                e.printStackTrace(Log.WARN);
            }
            return null;
        }
    }

    public static void downloadFile(File target, String url) throws IOException {
        DownloadUtils.downloadFile(false, target, url);
    }

    public static void downloadFile(boolean silent, File target, String url) throws IOException {
        if (!silent) {
            Log.quiet("Downloading " + url);
        }
        try (InputStream stream = DownloadUtils.connect(url);){
            Path path = target.toPath();
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.copy(stream, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new DownloadFailedException(url, e);
        }
    }

    public static boolean tryDownloadFile(boolean silent, File target, String url) {
        try {
            DownloadUtils.downloadFile(silent, target, url);
            return true;
        }
        catch (IOException e) {
            if (!silent) {
                e.printStackTrace(Log.WARN);
            }
            return false;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class DownloadFailedException
    extends IOException {
        public DownloadFailedException(String url, Throwable cause) {
            super("Failed to download " + url, cause);
        }
    }
}

