/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.shadow.net.minecraftforge.util.logging;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.shadow.net.minecraftforge.util.logging.DelegatePrintStream;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public final class Log {
    @Nullable
    public static Level enabled = Level.INFO;
    public static final PrintStream EMPTY = DelegatePrintStream.EMPTY;
    public static final PrintStream DEBUG = new DelegatePrintStream.Capturing(Level.DEBUG, System.out);
    public static final PrintStream QUIET = new DelegatePrintStream.Capturing(Level.QUIET, System.out);
    public static final PrintStream INFO = new DelegatePrintStream.Capturing(Level.INFO, System.out);
    public static final PrintStream WARN = new DelegatePrintStream.Capturing(Level.WARN, System.out);
    public static final PrintStream ERROR = new DelegatePrintStream.Capturing(Level.ERROR, System.err);
    public static final PrintStream FATAL = new DelegatePrintStream.Capturing(Level.FATAL, System.err);
    private static final String INDENT_STRING = "  ";
    private static final String[] INDENT_CACHE = new String[127];
    private static byte indentLevel = 0;
    static @UnknownNullability List<CapturedMessage> CAPTURED;

    public static byte push() {
        byte by = indentLevel;
        indentLevel = (byte)(by + 1);
        return by;
    }

    public static void pop() {
        if ((indentLevel = (byte)(indentLevel - 1)) < 0) {
            throw new IllegalStateException("Cannot pop Log below 0");
        }
    }

    public static void pop(byte indent) {
        if (indent < 0) {
            throw new IllegalArgumentException("Cannot pop Log below 0");
        }
        indentLevel = indent;
    }

    static String getIndentation() {
        String ret = INDENT_CACHE[indentLevel];
        return ret == null ? Log.getIndentation(indentLevel) : ret;
    }

    private static String getIndentation(byte indent) {
        StringBuilder builder = new StringBuilder(INDENT_STRING.length() * indent);
        for (int i = 0; i < indent; ++i) {
            builder.append(INDENT_STRING);
        }
        return builder.toString();
    }

    public static boolean isCapturing() {
        return CAPTURED != null;
    }

    public static void capture() {
        if (CAPTURED != null) {
            return;
        }
        CAPTURED = new ArrayList<CapturedMessage>(128);
    }

    static void tryCapture(Consumer<String> logger, Level level, String message) {
        if (CAPTURED != null) {
            CAPTURED.add(new CapturedMessage(level, message));
        } else {
            logger.accept(message);
        }
    }

    public static void drop() {
        CAPTURED = null;
    }

    public static void release() {
        Log.release(Log::logCaptured);
    }

    public static void release(BiConsumer<Level, String> consumer) {
        if (CAPTURED == null) {
            return;
        }
        Iterator<CapturedMessage> itor = CAPTURED.iterator();
        CAPTURED = null;
        while (itor.hasNext()) {
            CapturedMessage capture = itor.next();
            consumer.accept(capture.level, capture.message);
        }
    }

    private static void logCaptured(Level level, String message) {
        ((DelegatePrintStream)((Object)Log.getLog(level))).getDelegate().println(message);
    }

    public static PrintStream getLog(@Nullable Level level) {
        if (level == null) {
            return EMPTY;
        }
        switch (level) {
            case DEBUG: {
                return DEBUG;
            }
            case QUIET: {
                return QUIET;
            }
            case INFO: {
                return INFO;
            }
            case WARN: {
                return WARN;
            }
            case ERROR: {
                return ERROR;
            }
            case FATAL: {
                return FATAL;
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)level));
    }

    public static void log(Level level) {
        Log.getLog(level).println();
    }

    public static void log(Level level, Object message) {
        Log.getLog(level).println(message);
    }

    public static void log(Level level, Throwable throwable) {
        throwable.printStackTrace(Log.getLog(level));
    }

    public static void log(Level level, Object message, Throwable throwable) {
        Log.log(level, message);
        Log.log(level, throwable);
    }

    public static void debug() {
        Log.log(Level.DEBUG);
    }

    public static void debug(Object message) {
        Log.log(Level.DEBUG, message);
    }

    public static void debug(Throwable throwable) {
        Log.log(Level.DEBUG, throwable);
    }

    public static void debug(Object message, Throwable throwable) {
        Log.log(Level.DEBUG, message, throwable);
    }

    public static void quiet() {
        Log.log(Level.QUIET);
    }

    public static void quiet(Object message) {
        Log.log(Level.QUIET, message);
    }

    public static void quiet(Throwable throwable) {
        Log.log(Level.QUIET, throwable);
    }

    public static void quiet(Object message, Throwable throwable) {
        Log.log(Level.QUIET, message, throwable);
    }

    public static void info() {
        Log.log(Level.INFO);
    }

    public static void info(Object message) {
        Log.log(Level.INFO, message);
    }

    public static void info(Throwable throwable) {
        Log.log(Level.INFO, throwable);
    }

    public static void info(Object message, Throwable throwable) {
        Log.log(Level.INFO, message, throwable);
    }

    public static void warn() {
        Log.log(Level.WARN);
    }

    public static void warn(Object message) {
        Log.log(Level.WARN, message);
    }

    public static void warn(Throwable throwable) {
        Log.log(Level.WARN, throwable);
    }

    public static void warn(Object message, Throwable throwable) {
        Log.log(Level.WARN, message, throwable);
    }

    public static void error() {
        Log.log(Level.ERROR);
    }

    public static void error(Object message) {
        Log.log(Level.ERROR, message);
    }

    public static void error(Throwable throwable) {
        Log.log(Level.ERROR, throwable);
    }

    public static void error(Object message, Throwable throwable) {
        Log.log(Level.ERROR, message, throwable);
    }

    public static void fatal() {
        Log.log(Level.FATAL);
    }

    public static void fatal(Object message) {
        Log.log(Level.FATAL, message);
    }

    public static void fatal(Throwable throwable) {
        Log.log(Level.FATAL, throwable);
    }

    public static void fatal(Object message, Throwable throwable) {
        Log.log(Level.FATAL, message, throwable);
    }

    private Log() {
    }

    static {
        Log.INDENT_CACHE[0] = "";
        Log.INDENT_CACHE[1] = INDENT_STRING;
    }

    public static enum Level {
        DEBUG,
        QUIET,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }

    private static final class CapturedMessage {
        private final Level level;
        private final String message;

        private CapturedMessage(Level level, String message) {
            this.level = level;
            this.message = message;
        }
    }
}

