/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.Closures;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.EnhancedProblems;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.EnhancedTask;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.SharedUtil;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.Tool;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.ToolImpl;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyFactory;
import org.gradle.api.artifacts.dsl.ExternalModuleDependencyVariantSpec;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.LoggingManager;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public abstract class ToolExecBase<P extends EnhancedProblems>
extends DefaultTask
implements EnhancedTask<P> {
    private final P problems = (EnhancedProblems)this.getObjects().newInstance(this.problemsType(), new Object[0]);
    protected final DirectoryProperty defaultToolDir = this.getObjects().directoryProperty();
    private final ListProperty<String> additionalArgs = this.getObjects().listProperty(String.class);
    @Nullable
    private transient List<Provider<String>> args;
    @Nullable
    private transient List<Provider<String>> jvmArgs;
    @Nullable
    private transient Map<String, String> environment;
    @Nullable
    private transient Map<String, String> systemProperties;

    @Input
    @Optional
    public ListProperty<String> getAdditionalArgs() {
        return this.additionalArgs;
    }

    @InputFiles
    @Classpath
    public abstract ConfigurableFileCollection getClasspath();

    @Input
    @Optional
    public abstract Property<String> getMainClass();

    @Nested
    public abstract Property<JavaLauncher> getJavaLauncher();

    @Nested
    protected abstract Property<JavaLauncher> getToolchainLauncher();

    @Input
    @Optional
    public abstract Property<Boolean> getPreferToolchainJvm();

    @Internal
    public abstract DirectoryProperty getWorkingDir();

    @Internal
    protected abstract MapProperty<String, String> getForkProperties();

    @Deprecated
    public LoggingManager getLogging() {
        return super.getLogging();
    }

    @Console
    protected abstract Property<LogLevel> getStandardOutputLogLevel();

    @Console
    protected abstract Property<LogLevel> getStandardErrorLogLevel();

    @Internal
    protected abstract RegularFileProperty getLogFile();

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract ProviderFactory getProviders();

    @Inject
    protected abstract ExecOperations getExecOperations();

    @Inject
    protected abstract DependencyFactory getDependencyFactory();

    @Inject
    protected abstract JavaToolchainService getJavaToolchains();

    protected ToolExecBase(Tool tool) {
        Tool.Resolved resolved = this.getTool(tool);
        SharedUtil.finalizeProperty(this.defaultToolDir.value(this.globalCaches().dir(tool.getName().toLowerCase(Locale.ENGLISH)).map(this.ensureFileLocationInternal())));
        this.getClasspath().setFrom((Iterable)resolved.getClasspath());
        if (resolved.hasMainClass()) {
            this.getMainClass().set((Object)resolved.getMainClass());
        }
        this.getJavaLauncher().set(resolved.getJavaLauncher());
        this.getToolchainLauncher().convention(this.getJavaToolchains().launcherFor(spec -> spec.getLanguageVersion().set((Object)JavaLanguageVersion.current())));
        this.getProject().getPluginManager().withPlugin("java", javaAppliedPlugin -> this.getToolchainLauncher().set(this.getJavaToolchains().launcherFor(((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getToolchain())));
        this.getForkProperties().set(SharedUtil.getForkProperties(this.getProviders()));
        this.getStandardOutputLogLevel().convention((Object)LogLevel.LIFECYCLE);
        this.getStandardErrorLogLevel().convention((Object)LogLevel.ERROR);
        this.getWorkingDir().convention(this.getDefaultOutputDirectory());
        this.getLogFile().convention(this.getDefaultLogFile());
    }

    public final void using(CharSequence dependency) {
        this.using((Dependency)this.getDependencyFactory().create(dependency));
    }

    public final void using(Provider<? extends Dependency> dependency) {
        this.getClasspath().setFrom((Iterable)this.getProject().getConfigurations().detachedConfiguration(new Dependency[0]).withDependencies(d -> d.addLater(dependency)));
    }

    public final void using(Provider<MinimalExternalModuleDependency> dependency, Action<? super ExternalModuleDependencyVariantSpec> variantSpec) {
        this.using((Provider<Dependency>)this.getProject().getDependencies().variantOf(dependency, variantSpec));
    }

    public final void using(ProviderConvertible<? extends Dependency> dependency) {
        this.using((Provider<Dependency>)dependency.asProvider());
    }

    public final void using(ProviderConvertible<MinimalExternalModuleDependency> dependency, Action<? super ExternalModuleDependencyVariantSpec> variantSpec) {
        this.using((Provider<Dependency>)this.getProject().getDependencies().variantOf(dependency, variantSpec));
    }

    public final void using(Dependency dependency) {
        this.getClasspath().setFrom((Iterable)this.getProject().getConfigurations().detachedConfiguration(new Dependency[]{dependency}));
    }

    @Deprecated
    public final void usingDirectly(CharSequence downloadUrl) {
        String name = this.getName();
        Provider url = this.getProviders().provider(downloadUrl::toString);
        this.getClasspath().setFrom(new Object[]{this.getProviders().of(ToolImpl.Source.class, spec -> spec.parameters(parameters -> {
            parameters.getInputFile().set(this.getProviders().zip((Provider)this.localCaches(), url, (d, s) -> d.file("tools/" + name + "/" + s.substring(s.lastIndexOf(47)))));
            parameters.getDownloadUrl().set(url);
        }))});
    }

    @Internal
    protected final P getProblems() {
        return this.problems;
    }

    private <T extends FileSystemLocation> Transformer<T, T> ensureFileLocationInternal() {
        return t -> (FileSystemLocation)((EnhancedProblems)this.getProblems()).ensureFileLocation().transform(t);
    }

    @MustBeInvokedByOverriders
    protected void addArguments() {
    }

    @TaskAction
    protected ExecResult exec() throws IOException {
        JavaLauncher javaLauncher;
        Logger logger = this.getLogger();
        this.args = new ArrayList<Provider<String>>();
        this.jvmArgs = new ArrayList<Provider<String>>();
        this.environment = new HashMap<String, String>();
        this.systemProperties = new HashMap<String, String>();
        this.addArguments();
        this.args((Iterable)this.getAdditionalArgs().get());
        List args = DefaultGroovyMethods.collect(this.args, Closures.function(Provider::get));
        List jvmArgs = DefaultGroovyMethods.collect(this.jvmArgs, Closures.function(Provider::get));
        for (Map.Entry property : ((Map)this.getForkProperties().get()).entrySet()) {
            this.systemProperties.putIfAbsent((String)property.getKey(), (String)property.getValue());
        }
        LogLevel stdOutLevel = (LogLevel)this.getStandardOutputLogLevel().get();
        LogLevel stdErrLevel = (LogLevel)this.getStandardErrorLogLevel().get();
        if (((Boolean)this.getPreferToolchainJvm().getOrElse((Object)false)).booleanValue()) {
            JavaLauncher candidateLauncher = (JavaLauncher)this.getJavaLauncher().get();
            JavaLauncher toolchainLauncher = (JavaLauncher)this.getToolchainLauncher().get();
            javaLauncher = toolchainLauncher.getMetadata().getLanguageVersion().canCompileOrRun(candidateLauncher.getMetadata().getLanguageVersion()) ? toolchainLauncher : candidateLauncher;
        } else {
            javaLauncher = (JavaLauncher)this.getJavaLauncher().get();
        }
        File workingDirectory = ((Directory)this.getWorkingDir().map(((EnhancedProblems)this.problems).ensureFileLocation()).get()).getAsFile();
        try (PrintWriter log = new PrintWriter((Writer)new FileWriter((File)this.getLogFile().getAsFile().get()), true);){
            ExecResult execResult = this.getExecOperations().javaexec(spec -> {
                spec.setIgnoreExitValue(true);
                spec.setWorkingDir(workingDirectory);
                spec.setClasspath((FileCollection)this.getClasspath());
                if (this.getMainClass().isPresent()) {
                    spec.getMainClass().set(this.getMainClass());
                }
                spec.setExecutable(javaLauncher.getExecutablePath().getAsFile().getAbsolutePath());
                spec.setArgs(args);
                spec.setJvmArgs(jvmArgs);
                spec.setEnvironment(this.environment);
                spec.setSystemProperties(this.systemProperties);
                spec.setStandardOutput((OutputStream)SharedUtil.toLog(line -> {
                    logger.log(stdOutLevel, line);
                    log.println((String)line);
                }));
                spec.setErrorOutput((OutputStream)SharedUtil.toLog(line -> {
                    logger.log(stdErrLevel, line);
                    log.println((String)line);
                }));
                log.print("Java Launcher: ");
                log.println(spec.getExecutable());
                log.print("Working directory: ");
                log.println(spec.getWorkingDir().getAbsolutePath());
                log.print("Main class: ");
                log.println((String)spec.getMainClass().getOrElse((Object)"AUTOMATIC"));
                log.println("Arguments:");
                for (String s : spec.getArgs()) {
                    log.print("  ");
                    log.println(s);
                }
                log.println("JVM Arguments:");
                for (String s : spec.getAllJvmArgs()) {
                    log.print("  ");
                    log.println(s);
                }
                log.println("Classpath:");
                for (File f : this.getClasspath()) {
                    log.print("  ");
                    log.println(f.getAbsolutePath());
                }
                log.println("====================================");
            });
            return execResult;
        }
    }

    protected final void args(Object ... args) {
        this.args(Arrays.asList(args));
    }

    protected final void args(Iterable<?> args) {
        try {
            for (Object arg : args) {
                if (arg instanceof ProviderConvertible) {
                    ProviderConvertible providerConvertible = (ProviderConvertible)arg;
                    this.args.add((Provider<String>)providerConvertible.asProvider().map(Object::toString));
                }
                if (arg instanceof Provider) {
                    Provider provider = (Provider)arg;
                    this.args.add((Provider<String>)provider.map(Object::toString));
                    continue;
                }
                this.args.add((Provider<String>)this.getProviders().provider(arg::toString));
            }
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("ToolExecBase#jvmArgs can only be called inside of #addArguments()", e);
        }
    }

    protected final void args(String arg, Iterable<? extends File> files) {
        for (File file : files) {
            this.args(arg, file);
        }
    }

    protected final void args(String arg, FileSystemLocationProperty<? extends FileSystemLocation> fileProvider) {
        this.args(arg, fileProvider.getLocationOnly());
    }

    protected final void args(String arg, @UnknownNullability Provider<?> provider) {
        if (provider == null || !provider.isPresent()) {
            return;
        }
        Object value = provider.map(it -> it instanceof FileSystemLocation ? ((FileSystemLocation)it).getAsFile() : it).getOrNull();
        if (value == null) {
            return;
        }
        if (value instanceof Boolean) {
            Boolean booleanValue = (Boolean)value;
            if (booleanValue.booleanValue()) {
                this.args(arg);
            }
        } else {
            this.args(arg, String.valueOf(value));
        }
    }

    @Deprecated(forRemoval=true)
    protected final void args(Map<?, ?> args) {
        for (Map.Entry<?, ?> entry : args.entrySet()) {
            Provider provider;
            String string;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key instanceof Provider) {
                Provider provider2 = (Provider)key;
                string = (String)provider2.map(Object::toString).get();
            } else {
                string = (String)this.getProviders().provider(key::toString).get();
            }
            if (value instanceof Provider) {
                Provider provider3 = (Provider)value;
                if (provider3 instanceof FileSystemLocationProperty) {
                    FileSystemLocationProperty file = (FileSystemLocationProperty)provider3;
                    provider = file.getLocationOnly();
                } else {
                    provider = provider3;
                }
            } else {
                provider = this.getProviders().provider(() -> value);
            }
            this.args(string, provider);
        }
    }

    protected final void jvmArgs(Object ... args) {
        try {
            for (Object arg : args) {
                this.jvmArgs.add((Provider<String>)this.getProviders().provider(arg::toString));
            }
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("ToolExecBase#jvmArgs can only be called inside of #addArguments()", e);
        }
    }

    protected final void jvmArgs(Iterable<?> args) {
        try {
            for (Object arg : args) {
                this.jvmArgs.add((Provider<String>)this.getProviders().provider(arg::toString));
            }
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("ToolExecBase#jvmArgs can only be called inside of #addArguments()", e);
        }
    }

    protected final void environment(String key, String value) {
        try {
            this.environment.put(key, value);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("ToolExecBase#environment can only be called inside of #addArguments()", e);
        }
    }

    protected final void systemProperty(String key, String value) {
        try {
            this.systemProperties.put(key, value);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("ToolExecBase#systemProperty can only be called inside of #addArguments()", e);
        }
    }
}

