/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.java.archives.internal.ManifestInternal;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.tasks.Jar;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@ApiStatus.Experimental
public abstract class WriteManifest
extends DefaultTask {
    @Input
    protected abstract Property<byte[]> getInputBytes();

    @OutputFile
    protected abstract RegularFileProperty getOutput();

    @Inject
    protected abstract ProjectLayout getLayout();

    @Inject
    public WriteManifest(TaskProvider<? extends Jar> jar) {
        this.getOutput().value(this.getLayout().getBuildDirectory().file(this.getName() + "/MANIFEST.MF")).disallowChanges();
        TaskContainer tasks = this.getProject().getTasks();
        SourceSet sourceSet = this.findSourceSet(jar.getName());
        tasks.named(sourceSet.getProcessResourcesTaskName(), ProcessResources.class, processResources -> {
            processResources.dependsOn(new Object[]{this});
            processResources.from((Object)this, copy -> {
                copy.into((Object)"META-INF");
                copy.setDuplicatesStrategy(DuplicatesStrategy.INCLUDE);
            });
        });
        Action afterEvaluate = project -> {
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                ((ManifestInternal)((Jar)jar.get()).getManifest()).writeTo((OutputStream)os);
                this.getInputBytes().value((Object)os.toByteArray()).finalizeValue();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        try {
            this.getProject().afterEvaluate(afterEvaluate);
        }
        catch (Exception ignored) {
            afterEvaluate.execute((Object)this.getProject());
        }
    }

    @TaskAction
    protected void exec() throws IOException {
        Files.write(((File)this.getOutput().getAsFile().get()).toPath(), (byte[])this.getInputBytes().get(), new OpenOption[0]);
    }

    private SourceSet findSourceSet(String jarTaskName) {
        JavaPluginExtension java = (JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class);
        Iterator candidates = java.getSourceSets().matching(sourceSet -> sourceSet.getJarTaskName().equals(jarTaskName)).iterator();
        return candidates.hasNext() ? (SourceSet)candidates.next() : (SourceSet)java.getSourceSets().getByName("main");
    }
}

