/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils;

import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.gradleutils.PomUtils;
import org.gradle.api.Action;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.MavenPomDeveloper;
import org.gradle.api.publish.maven.MavenPomLicense;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

interface PomUtilsInternal
extends PomUtils,
HasPublicType {
    default public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(PomUtils.class);
    }

    public static Action<MavenPomLicense> makeLicense(String name, String url) {
        return license -> {
            license.getName().set((Object)name);
            license.getUrl().set((Object)url);
            license.getDistribution().set((Object)"repo");
        };
    }

    public static Map<String, Action<? super MavenPomDeveloper>> makeDevelopers() {
        return PomUtilsInternal.makeDevelopers(Map.of("LexManos", PomUtilsInternal.makeDev("LexManos", "Lex Manos"), "Paint_Ninja", PomUtilsInternal.makeDev("Paint_Ninja"), "Jonathing", PomUtilsInternal.makeDev("Jonathing", "me@jonathing.me", "https://jonathing.me", "America/New_York")));
    }

    private static Map<String, Action<? super MavenPomDeveloper>> makeDevelopers(Map<String, Action<? super MavenPomDeveloper>> defaults) {
        return new HashMap<String, Action<? super MavenPomDeveloper>>(defaults){
            private static final long serialVersionUID = -9033218614762684158L;

            @Override
            public Action<? super MavenPomDeveloper> get(Object key) {
                this.ensure((String)key);
                return (Action)super.get(key);
            }

            private void ensure(String key) {
                if (!this.containsKey(key)) {
                    this.put(key, PomUtilsInternal.makeDev(key));
                }
            }
        };
    }

    private static Action<? super MavenPomDeveloper> makeDev(String id) {
        return PomUtilsInternal.makeDev(id, id);
    }

    private static Action<? super MavenPomDeveloper> makeDev(String id, String name) {
        return developer -> {
            developer.getId().set((Object)id);
            developer.getName().set((Object)name);
            developer.getRoles().add((Object)"developer");
        };
    }

    private static Action<? super MavenPomDeveloper> makeDev(String id, String email, String url, String timezone) {
        return PomUtilsInternal.makeDev(id, id, email, url, timezone);
    }

    private static Action<? super MavenPomDeveloper> makeDev(String id, String name, String email, String url, String timezone) {
        return developer -> {
            developer.getId().set((Object)id);
            developer.getName().set((Object)name);
            developer.getEmail().set((Object)email);
            developer.getUrl().set((Object)url);
            developer.getTimezone().set((Object)timezone);
            developer.getRoles().add((Object)"developer");
        };
    }

    @Override
    @MustBeInvokedByOverriders
    default public void addRemoteDetails(MavenPom pom, String url) {
        if (url == null || url.isBlank()) {
            throw new IllegalArgumentException();
        }
        String strippedUrl = PomUtilsInternal.stripProtocol(url);
        String fullURL = "https://" + strippedUrl;
        pom.getUrl().set((Object)fullURL);
        pom.scm(scm -> {
            scm.getUrl().set((Object)fullURL);
            scm.getConnection().set((Object)"scm:git:git://%s.git".formatted(strippedUrl));
            scm.getDeveloperConnection().set((Object)"scm:git:git@%s.git".formatted(strippedUrl.replaceFirst("/", ":")));
        });
        if (!strippedUrl.contains("github.com")) {
            return;
        }
        pom.issueManagement(issues -> {
            issues.getSystem().set((Object)"github");
            issues.getUrl().set((Object)(fullURL + "/issues"));
        });
        pom.ciManagement(ci -> {
            ci.getSystem().set((Object)"github");
            ci.getUrl().set((Object)(fullURL + "/actions"));
        });
        if (!strippedUrl.contains("github.com/MinecraftForge/")) {
            return;
        }
        pom.organization(organization -> {
            organization.getName().set((Object)"Forge Development LLC");
            organization.getUrl().set((Object)"https://minecraftforge.net");
        });
    }

    private static String stripProtocol(String url) {
        int protocolIdx = url.indexOf("://");
        String ret = protocolIdx == -1 ? url : url.substring(protocolIdx + "://".length());
        return ret.endsWith("/") ? ret.substring(0, ret.length() - 1) : ret;
    }

    public static interface Licenses
    extends PomUtils.Licenses,
    HasPublicType {
        default public TypeOf<?> getPublicType() {
            return TypeOf.typeOf(PomUtils.Licenses.class);
        }
    }
}

