/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.SharedUtil;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.Tool;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.ToolInternal;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.ToolsExtensionImpl;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.shadow.net.minecraftforge.util.download.DownloadUtils;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.shadow.net.minecraftforge.util.hash.HashStore;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.jetbrains.annotations.Nullable;

record ToolImpl(String getName, String getVersion, String fileName, String downloadUrl, int getJavaVersion, @Nullable String getMainClass) implements ToolInternal
{
    private static final long serialVersionUID = -862411638019629688L;
    private static final Logger LOGGER = Logging.getLogger(Tool.class);

    ToolImpl(String name, String version, String downloadUrl, int javaVersion, @Nullable String mainClass) {
        this(name, version, String.format("%s-%s.jar", name, version), downloadUrl, javaVersion, mainClass);
    }

    @Override
    public Tool.Resolved get(Provider<? extends Directory> cachesDir, ProviderFactory providers, ToolsExtensionImpl toolsExt) {
        Tool.Definition definition = (Tool.Definition)toolsExt.definitions.maybeCreate(this.getName());
        ConfigurableFileCollection classpath = definition.getClasspath();
        if (classpath.isEmpty()) {
            classpath = toolsExt.getObjects().fileCollection().from(new Object[]{providers.of(Source.class, spec -> spec.parameters(parameters -> {
                parameters.getInputFile().set(cachesDir.map(d -> d.file("tools/" + this.fileName)));
                parameters.getDownloadUrl().set((Object)this.downloadUrl);
            }))});
        }
        return new ResolvedImpl(toolsExt.getObjects(), (FileCollection)classpath, (Provider<? extends String>)definition.getMainClass().orElse(providers.provider(this::getMainClass)), (Provider<? extends JavaLauncher>)definition.getJavaLauncher().orElse(providers.provider(() -> (JavaLauncher)SharedUtil.launcherForStrictly(toolsExt.javaToolchains.call(), this.getJavaVersion()).get())));
    }

    static abstract class Source
    implements ValueSource<File, Parameters> {
        @Inject
        public Source() {
        }

        public File obtain() {
            Parameters parameters = (Parameters)this.getParameters();
            String downloadUrl = (String)parameters.getDownloadUrl().get();
            File outFile = ((RegularFile)parameters.getInputFile().get()).getAsFile();
            String name = outFile.getName();
            HashStore cache = HashStore.fromFile(outFile).add("url", downloadUrl);
            if (outFile.exists() && cache.isSame()) {
                LOGGER.info("Default tool already downloaded: {}", (Object)name);
            } else {
                LOGGER.info("Downloading default tool: {}", (Object)name);
                try {
                    DownloadUtils.downloadFile(outFile, downloadUrl);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to download default tool: " + name, e);
                }
                cache.save();
            }
            return outFile;
        }

        static interface Parameters
        extends ValueSourceParameters {
            public RegularFileProperty getInputFile();

            public Property<String> getDownloadUrl();
        }
    }

    final class ResolvedImpl
    implements ToolInternal.Resolved {
        private final FileCollection classpath;
        private final Property<String> mainClass;
        private final Property<JavaLauncher> javaLauncher;

        private ResolvedImpl(ObjectFactory objects, FileCollection classpath, Provider<? extends String> mainClass, Provider<? extends JavaLauncher> javaLauncher) {
            this.classpath = classpath;
            this.mainClass = objects.property(String.class).value(mainClass);
            this.javaLauncher = objects.property(JavaLauncher.class).value(javaLauncher);
        }

        @Override
        public FileCollection getClasspath() {
            return this.classpath;
        }

        @Override
        public String getName() {
            return ToolImpl.this.getName();
        }

        @Override
        public String getVersion() {
            return ToolImpl.this.getVersion();
        }

        @Override
        public Property<JavaLauncher> getJavaLauncher() {
            return this.javaLauncher;
        }

        @Override
        public int getJavaVersion() {
            return ((JavaLauncher)this.javaLauncher.get()).getMetadata().getLanguageVersion().asInt();
        }

        @Override
        @Nullable
        public String getMainClass() {
            return (String)this.mainClass.getOrNull();
        }
    }

    static abstract class DefinitionImpl
    implements ToolInternal.Definition {
        private final String name;
        private final ConfigurableFileCollection classpath = this.getObjects().fileCollection();
        private final Property<String> mainClass = this.getObjects().property(String.class);
        private final Property<JavaLauncher> javaLauncher = this.getObjects().property(JavaLauncher.class);

        @Inject
        protected abstract ObjectFactory getObjects();

        @Inject
        public DefinitionImpl(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public ConfigurableFileCollection getClasspath() {
            return this.classpath;
        }

        @Override
        public Property<String> getMainClass() {
            return this.mainClass;
        }

        @Override
        public Property<JavaLauncher> getJavaLauncher() {
            return this.javaLauncher;
        }
    }
}

