/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.FirstParam;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.Closures;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public abstract class SharedUtil {
    public static final Transformer<String, JavaLauncher> LAUNCHER_EXECUTABLE = it -> it.getExecutablePath().toString();

    public static Provider<JavaLauncher> launcherFor(Project project, int version) {
        return SharedUtil.launcherFor(project, JavaLanguageVersion.of((int)version));
    }

    public static Provider<JavaLauncher> launcherFor(Project project, JavaLanguageVersion version) {
        ProviderFactory providers = project.getProviders();
        ExtensionContainer extensions = project.getExtensions();
        return SharedUtil.launcherFor((Provider<? extends JavaPluginExtension>)providers.provider(() -> (JavaPluginExtension)extensions.findByType(JavaPluginExtension.class)), SharedUtil.getJavaToolchainService(project), version);
    }

    private static Provider<JavaLauncher> launcherFor(Provider<? extends JavaPluginExtension> java, JavaToolchainService javaToolchains, int version) {
        return SharedUtil.launcherFor(java, javaToolchains, JavaLanguageVersion.of((int)version));
    }

    private static Provider<JavaLauncher> launcherFor(Provider<? extends JavaPluginExtension> java, JavaToolchainService javaToolchains, JavaLanguageVersion version) {
        return java.flatMap(j -> SharedUtil.launcherFor(j, javaToolchains, version)).orElse(SharedUtil.launcherFor(javaToolchains, version));
    }

    private static Provider<JavaLauncher> launcherFor(JavaPluginExtension java, JavaToolchainService javaToolchains, int version) {
        return SharedUtil.launcherFor(java, javaToolchains, JavaLanguageVersion.of((int)version));
    }

    private static Provider<JavaLauncher> launcherFor(JavaPluginExtension java, JavaToolchainService javaToolchains, JavaLanguageVersion version) {
        return java.getToolchain().getLanguageVersion().orElse((Object)JavaLanguageVersion.current()).flatMap(languageVersion -> languageVersion.canCompileOrRun(version) ? javaToolchains.launcherFor(spec -> spec.getLanguageVersion().set(languageVersion)) : SharedUtil.launcherForStrictly(javaToolchains, version));
    }

    private static Provider<JavaLauncher> launcherFor(JavaToolchainService javaToolchains, int version) {
        return SharedUtil.launcherFor(javaToolchains, JavaLanguageVersion.of((int)version));
    }

    private static Provider<JavaLauncher> launcherFor(JavaToolchainService javaToolchains, JavaLanguageVersion version) {
        JavaLanguageVersion languageVersion = JavaLanguageVersion.current();
        return languageVersion.canCompileOrRun(version) ? javaToolchains.launcherFor(spec -> spec.getLanguageVersion().set((Object)languageVersion)) : SharedUtil.launcherForStrictly(javaToolchains, version);
    }

    public static Provider<JavaLauncher> launcherForStrictly(Project project, int version) {
        return SharedUtil.launcherForStrictly(SharedUtil.getJavaToolchainService(project), version);
    }

    public static Provider<JavaLauncher> launcherForStrictly(Project project, JavaLanguageVersion version) {
        return SharedUtil.launcherForStrictly(SharedUtil.getJavaToolchainService(project), version);
    }

    public static Provider<JavaLauncher> launcherForStrictly(JavaToolchainService javaToolchains, int version) {
        return SharedUtil.launcherForStrictly(javaToolchains, JavaLanguageVersion.of((int)version));
    }

    public static Provider<JavaLauncher> launcherForStrictly(JavaToolchainService javaToolchains, JavaLanguageVersion version) {
        return javaToolchains.launcherFor(spec -> spec.getLanguageVersion().set((Object)version));
    }

    private static JavaToolchainService getJavaToolchainService(Project project) {
        return ((ProjectServiceWrapper)project.getObjects().newInstance(ProjectServiceWrapper.class, new Object[0])).getJavaToolchains();
    }

    public static void ensureAfterEvaluate(Project project, @DelegatesTo(value=Project.class, strategy=1) @ClosureParams(value=FirstParam.class) Closure<?> closure) {
        SharedUtil.ensureAfterEvaluate(project, Closures.toAction(closure));
    }

    public static void ensureAfterEvaluate(Project project, Action<? super Project> action) {
        if (project.getState().getExecuted()) {
            action.execute((Object)project);
        } else {
            project.afterEvaluate(action);
        }
    }

    public static <T extends TaskProvider<?>> T runFirst(Project project, final T task) {
        ArrayList<1> requests = new ArrayList<1>(project.getGradle().getStartParameter().getTaskRequests());
        requests.add(0, new TaskExecutionRequest(){

            public List<String> getArgs() {
                return List.of(((Task)task.get()).getPath());
            }

            @Nullable
            public String getProjectPath() {
                return null;
            }

            @Nullable
            public File getRootDir() {
                return null;
            }
        });
        project.getLogger().info("Adding task to beginning of task graph! Project: {}, Task: {}", (Object)project.getName(), (Object)task.getName());
        project.getGradle().getStartParameter().setTaskRequests(requests);
        return task;
    }

    public static boolean contains(ConfigurationContainer configurations, SourceSet sourceSet, boolean transitive, Dependency dependency) {
        return SharedUtil.contains(configurations, sourceSet, transitive, (Spec<? super Dependency>)((Spec)dependency::equals));
    }

    public static boolean contains(ConfigurationContainer configurations, SourceSet sourceSet, boolean transitive, Spec<? super Dependency> dependency) {
        return SharedUtil.contains(configurations, sourceSet.getCompileOnlyConfigurationName(), transitive, dependency) || SharedUtil.contains(configurations, sourceSet.getCompileOnlyApiConfigurationName(), transitive, dependency) || SharedUtil.contains(configurations, sourceSet.getCompileClasspathConfigurationName(), transitive, dependency) || SharedUtil.contains(configurations, sourceSet.getAnnotationProcessorConfigurationName(), transitive, dependency) || SharedUtil.contains(configurations, sourceSet.getApiConfigurationName(), transitive, dependency) || SharedUtil.contains(configurations, sourceSet.getImplementationConfigurationName(), transitive, dependency) || SharedUtil.contains(configurations, sourceSet.getApiElementsConfigurationName(), transitive, dependency) || SharedUtil.contains(configurations, sourceSet.getRuntimeOnlyConfigurationName(), transitive, dependency) || SharedUtil.contains(configurations, sourceSet.getRuntimeClasspathConfigurationName(), transitive, dependency) || SharedUtil.contains(configurations, sourceSet.getRuntimeElementsConfigurationName(), transitive, dependency);
    }

    private static boolean contains(ConfigurationContainer configurations, String configurationName, boolean transitive, Spec<? super Dependency> dependency) {
        Configuration configuration = (Configuration)configurations.findByName(configurationName);
        return configuration != null && !(transitive ? configuration.getAllDependencies() : configuration.getDependencies()).matching(dependency).isEmpty();
    }

    public static Set<Dependency> collect(ConfigurationContainer configurations, SourceSet sourceSet, boolean transitive, Predicate<? super Dependency> dependency) {
        return Stream.of((Configuration)configurations.findByName(sourceSet.getCompileOnlyConfigurationName()), (Configuration)configurations.findByName(sourceSet.getCompileOnlyApiConfigurationName()), (Configuration)configurations.findByName(sourceSet.getCompileClasspathConfigurationName()), (Configuration)configurations.findByName(sourceSet.getAnnotationProcessorConfigurationName()), (Configuration)configurations.findByName(sourceSet.getApiConfigurationName()), (Configuration)configurations.findByName(sourceSet.getImplementationConfigurationName()), (Configuration)configurations.findByName(sourceSet.getApiElementsConfigurationName()), (Configuration)configurations.findByName(sourceSet.getRuntimeOnlyConfigurationName()), (Configuration)configurations.findByName(sourceSet.getRuntimeClasspathConfigurationName()), (Configuration)configurations.findByName(sourceSet.getRuntimeElementsConfigurationName())).filter(Objects::nonNull).flatMap(configuration -> transitive ? configuration.getAllDependencies().stream() : configuration.getDependencies().stream()).distinct().filter(dependency).collect(Collectors.toSet());
    }

    private static <T> void guardCheck(T t) {
    }

    public static void forEachClasspath(ConfigurationContainer configurations, SourceSet sourceSet, Action<? super Configuration> action) {
        SharedUtil.forEach(configurations.named(name -> name.equals(sourceSet.getCompileClasspathConfigurationName()) || name.equals(sourceSet.getRuntimeClasspathConfigurationName())), action);
    }

    public static void forEachClasspathEagerly(ConfigurationContainer configurations, SourceSet sourceSet, Action<? super Configuration> action) {
        SharedUtil.forEachEagerly(configurations.named(name -> name.equals(sourceSet.getCompileClasspathConfigurationName()) || name.equals(sourceSet.getRuntimeClasspathConfigurationName())), action);
    }

    public static <T> void forEach(DomainObjectCollection<T> collection, Action<? super T> action) {
        boolean eager = false;
        try {
            collection.configureEach(SharedUtil::guardCheck);
        }
        catch (IllegalStateException e) {
            eager = true;
        }
        if (eager) {
            collection.forEach(arg_0 -> action.execute(arg_0));
        } else {
            collection.configureEach(action);
        }
    }

    public static <T> void forEachEagerly(DomainObjectCollection<T> collection, Action<? super T> action) {
        List.copyOf(collection).forEach(arg_0 -> action.execute(arg_0));
    }

    public static PipedOutputStream toLog(Logger logger, LogLevel level) {
        return SharedUtil.toLog(s -> logger.log(level, s));
    }

    public static PipedOutputStream toLog(Consumer<? super String> logger) {
        PipedInputStream input;
        PipedOutputStream output;
        try {
            output = new PipedOutputStream();
            input = new PipedInputStream(output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Thread thread = new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
                reader.lines().forEach(logger);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        thread.setDaemon(true);
        thread.start();
        return output;
    }

    public static String toString(ModuleVersionSelector module) {
        String version = module.getVersion();
        return String.format("%s:%s%s", module.getGroup(), module.getName(), version != null ? ":" + version : "");
    }

    public static String toString(Dependency dependency) {
        String string;
        String group = dependency.getGroup();
        String version = dependency.getVersion();
        String reason = dependency.getReason();
        Object[] objectArray = new Object[6];
        objectArray[0] = dependency.getClass().getName();
        objectArray[1] = group != null ? group + ":" : "";
        objectArray[2] = dependency.getName();
        objectArray[3] = version != null ? ":" + version : "";
        Object object = objectArray[4] = reason != null ? " (" + reason + ")" : "";
        if (dependency instanceof FileCollectionDependency) {
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = String.join((CharSequence)", ", ((FileCollectionDependency)dependency).getFiles().getFiles().stream().map(File::getAbsolutePath).map(CharSequence.class::cast)::iterator);
            string = String.format(" [%s]", objectArray2);
        } else {
            string = "";
        }
        objectArray[5] = string;
        return String.format("(%s) %s%s%s%s%s", objectArray);
    }

    public static <P extends Property<?>> Closure<P> finalizeProperty() {
        Closure ret = Closures.unaryOperator(SharedUtil::finalizeProperty);
        ret.setResolveStrategy(1);
        return ret;
    }

    @Contract(value="_ -> param1", mutates="param1")
    public static <P extends Property<?>> P finalizeProperty(P property) {
        property.disallowChanges();
        property.finalizeValueOnRead();
        return property;
    }

    public static <T> void setOptional(Property<T> to, Provider<? extends T> from) {
        if (from.isPresent()) {
            to.set(from);
        }
    }

    protected SharedUtil() {
    }

    static abstract class ProjectServiceWrapper {
        @Inject
        protected abstract JavaToolchainService getJavaToolchains();

        @Inject
        public ProjectServiceWrapper() {
        }
    }
}

