/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.EnhancedProblems;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.EnhancedTask;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.SharedUtil;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.Tool;
import org.gradle.api.Transformer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.UnknownNullability;

public abstract class ToolExecBase<P extends EnhancedProblems>
extends JavaExec
implements EnhancedTask<P> {
    private final P problems;
    protected final DirectoryProperty defaultToolDir = this.getObjectFactory().directoryProperty();
    private final ListProperty<String> additionalArgs = this.getObjectFactory().listProperty(String.class);

    @Input
    @Optional
    public ListProperty<String> getAdditionalArgs() {
        return this.additionalArgs;
    }

    protected ToolExecBase(Tool tool) {
        this.problems = (EnhancedProblems)this.getObjectFactory().newInstance(this.problemsType(), new Object[0]);
        Tool.Resolved resolved = this.getTool(tool);
        this.defaultToolDir.value(this.globalCaches().dir(tool.getName().toLowerCase(Locale.ENGLISH)).map(this.ensureFileLocationInternal()));
        this.setClasspath(resolved.getClasspath());
        SharedUtil.finalizeProperty(this.defaultToolDir);
        if (resolved.hasMainClass()) {
            this.getMainClass().set((Object)resolved.getMainClass());
        }
        this.getJavaLauncher().set(resolved.getJavaLauncher());
        this.getLogging().captureStandardOutput(LogLevel.LIFECYCLE).captureStandardError(LogLevel.ERROR);
    }

    @Internal
    protected final P getProblems() {
        return this.problems;
    }

    private <T extends FileSystemLocation> Transformer<T, T> ensureFileLocationInternal() {
        return t -> (FileSystemLocation)((EnhancedProblems)this.getProblems()).ensureFileLocation().transform(t);
    }

    @MustBeInvokedByOverriders
    protected void addArguments() {
        this.args((Iterable)this.getAdditionalArgs().get());
    }

    public void exec() {
        if (!this.getArgs().isEmpty()) {
            ((EnhancedProblems)this.getProblems()).reportToolExecEagerArgs(this);
        }
        this.addArguments();
        this.getLogger().info("{} {}", (Object)this.getClasspath().getAsPath(), (Object)String.join((CharSequence)" ", this.getArgs()));
        super.exec();
    }

    protected final void args(String arg, Iterable<? extends File> files) {
        for (File file : files) {
            this.args(new Object[]{arg, file});
        }
    }

    protected final void args(String arg, FileSystemLocationProperty<? extends FileSystemLocation> fileProvider) {
        this.args(arg, fileProvider.getLocationOnly());
    }

    protected final void args(String arg, @UnknownNullability Provider<?> provider) {
        if (provider == null || !provider.isPresent()) {
            return;
        }
        Object value = provider.map(it -> it instanceof FileSystemLocation ? ((FileSystemLocation)it).getAsFile() : it).getOrNull();
        if (value == null) {
            return;
        }
        if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
            this.args(new Object[]{arg});
        } else {
            this.args(new Object[]{arg, String.valueOf(value)});
        }
    }

    protected final void args(Map<?, ?> args) {
        for (Map.Entry<?, ?> entry : args.entrySet()) {
            Provider provider;
            String string;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key instanceof Provider) {
                Provider provider2 = (Provider)key;
                string = (String)provider2.map(Object::toString).get();
            } else {
                string = (String)this.getProviderFactory().provider(key::toString).get();
            }
            if (value instanceof Provider) {
                Provider provider3 = (Provider)value;
                if (provider3 instanceof FileSystemLocationProperty) {
                    FileSystemLocationProperty file = (FileSystemLocationProperty)provider3;
                    provider = file.getLocationOnly();
                } else {
                    provider = provider3;
                }
            } else {
                provider = this.getProviderFactory().provider(() -> value);
            }
            this.args(string, provider);
        }
    }
}

