/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared;

import java.io.File;
import java.util.Locale;
import javax.inject.Inject;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.EnhancedProblems;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.EnhancedTask;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.SharedUtil;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.Tool;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.ToolInternal;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.ToolsExtensionImpl;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public abstract class ToolExecBase<P extends EnhancedProblems>
extends JavaExec {
    private final P problems;
    protected final DirectoryProperty defaultToolDir;

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    protected ToolExecBase(Class<P> problemsType, Tool tool) {
        Tool.Resolved resolved;
        this.problems = (EnhancedProblems)this.getObjectFactory().newInstance(problemsType, new Object[0]);
        if (this instanceof EnhancedTask) {
            resolved = ((EnhancedTask)((Object)this)).getTool(tool);
            this.defaultToolDir = this.getObjectFactory().directoryProperty().value(((EnhancedTask)((Object)this)).globalCaches().dir(tool.getName().toLowerCase(Locale.ENGLISH)).map(this.ensureFileLocationInternal()));
        } else {
            this.getProject().afterEvaluate(project -> ((EnhancedProblems)this.getProblems()).reportToolExecNotEnhanced((Task)this));
            resolved = ((ToolInternal)tool).get((Provider<? extends Directory>)this.getProjectLayout().getBuildDirectory().dir("minecraftforge/tools/" + tool.getName().toLowerCase(Locale.ENGLISH)).map(this.ensureFileLocationInternal()), (ToolsExtensionImpl)this.getObjectFactory().newInstance(ToolsExtensionImpl.class, new Object[0]));
            this.defaultToolDir = this.getObjectFactory().directoryProperty().value(this.getProjectLayout().getBuildDirectory().dir(String.format("minecraftforge/tools/%s/workDir", tool.getName().toLowerCase(Locale.ENGLISH))).map(this.ensureFileLocationInternal()));
        }
        this.setClasspath(resolved.getClasspath());
        this.defaultToolDir.disallowChanges();
        this.defaultToolDir.finalizeValueOnRead();
        if (resolved.hasMainClass()) {
            this.getMainClass().set((Object)resolved.getMainClass());
        }
        this.getJavaLauncher().set(resolved.getJavaLauncher());
        this.setStandardOutput(SharedUtil.toLog(arg_0 -> ((Logger)this.getLogger()).lifecycle(arg_0)));
        this.setErrorOutput(SharedUtil.toLog(arg_0 -> ((Logger)this.getLogger()).error(arg_0)));
    }

    @Internal
    protected final P getProblems() {
        return this.problems;
    }

    private <T extends FileSystemLocation> Transformer<T, T> ensureFileLocationInternal() {
        return t -> (FileSystemLocation)((EnhancedProblems)this.getProblems()).ensureFileLocation().transform(t);
    }

    @MustBeInvokedByOverriders
    protected void addArguments() {
    }

    public void exec() {
        if (this.getArgs().isEmpty()) {
            this.addArguments();
        } else {
            ((EnhancedProblems)this.getProblems()).reportToolExecEagerArgs((Task)this);
        }
        this.getLogger().info("{} {}", (Object)this.getClasspath().getAsPath(), (Object)String.join((CharSequence)" ", this.getArgs()));
        super.exec();
    }

    protected final void args(String arg, Iterable<? extends File> files) {
        for (File file : files) {
            this.args(new Object[]{arg, file});
        }
    }

    protected final void args(String arg, FileSystemLocationProperty<? extends FileSystemLocation> fileProvider) {
        this.args(arg, fileProvider.getLocationOnly());
    }

    protected final void args(String arg, Provider<?> provider) {
        Object value = provider.map(it -> it instanceof FileSystemLocation ? ((FileSystemLocation)it).getAsFile() : it).get();
        this.args(new Object[]{arg, String.valueOf(value)});
    }

    protected final void argOnlyIf(String arg, Provider<Boolean> onlyIf) {
        this.argOnlyIf(arg, task -> onlyIf.isPresent() && (Boolean)onlyIf.getOrElse((Object)false) != false);
    }

    protected final void argOnlyIf(String arg, Spec<? super ToolExecBase<?>> onlyIf) {
        if (onlyIf.isSatisfiedBy((Object)this)) {
            this.args(new Object[]{arg});
        }
    }
}

