/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.EnhancedProblems;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.EnhancedTask;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.SharedUtil;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.Tool;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.ToolInternal;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.ToolsExtensionImpl;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.UnknownNullability;

public abstract class ToolExecBase<P extends EnhancedProblems>
extends JavaExec {
    private final P problems;
    protected final DirectoryProperty defaultToolDir = this.getObjectFactory().directoryProperty();
    private final ListProperty<String> additionalArgs = this.getObjectFactory().listProperty(String.class);

    @Input
    @Optional
    public ListProperty<String> getAdditionalArgs() {
        return this.additionalArgs;
    }

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    protected ToolExecBase(Class<P> problemsType, Tool tool) {
        Tool.Resolved resolved;
        this.problems = (EnhancedProblems)this.getObjectFactory().newInstance(problemsType, new Object[0]);
        if (this instanceof EnhancedTask) {
            resolved = ((EnhancedTask)((Object)this)).getTool(tool);
            this.defaultToolDir.value(((EnhancedTask)((Object)this)).globalCaches().dir(tool.getName().toLowerCase(Locale.ENGLISH)).map(this.ensureFileLocationInternal()));
        } else {
            this.getProject().afterEvaluate(project -> ((EnhancedProblems)this.getProblems()).reportToolExecNotEnhanced((Task)this));
            resolved = ((ToolInternal)tool).get((Provider<? extends Directory>)this.getProjectLayout().getBuildDirectory().dir("minecraftforge/tools/" + tool.getName().toLowerCase(Locale.ENGLISH)).map(this.ensureFileLocationInternal()), this.getProviderFactory(), (ToolsExtensionImpl)this.getObjectFactory().newInstance(ToolsExtensionImpl.class, new Object[]{() -> ((ToolExecBase)this).getJavaToolchainService()}));
            this.defaultToolDir.value(this.getProjectLayout().getBuildDirectory().dir(String.format("minecraftforge/tools/%s/workDir", tool.getName().toLowerCase(Locale.ENGLISH))).map(this.ensureFileLocationInternal()));
        }
        this.setClasspath(resolved.getClasspath());
        SharedUtil.finalizeProperty(this.defaultToolDir);
        if (resolved.hasMainClass()) {
            this.getMainClass().set((Object)resolved.getMainClass());
        }
        this.getJavaLauncher().set(resolved.getJavaLauncher());
        this.getLogging().captureStandardOutput(LogLevel.LIFECYCLE).captureStandardError(LogLevel.ERROR);
    }

    @Internal
    protected final P getProblems() {
        return this.problems;
    }

    private <T extends FileSystemLocation> Transformer<T, T> ensureFileLocationInternal() {
        return t -> (FileSystemLocation)((EnhancedProblems)this.getProblems()).ensureFileLocation().transform(t);
    }

    @MustBeInvokedByOverriders
    protected void addArguments() {
        this.args((Iterable)this.getAdditionalArgs().get());
    }

    public void exec() {
        if (!this.getArgs().isEmpty()) {
            ((EnhancedProblems)this.getProblems()).reportToolExecEagerArgs((Task)this);
        }
        this.addArguments();
        this.getLogger().info("{} {}", (Object)this.getClasspath().getAsPath(), (Object)String.join((CharSequence)" ", this.getArgs()));
        super.exec();
    }

    protected final void args(String arg, Iterable<? extends File> files) {
        for (File file : files) {
            this.args(new Object[]{arg, file});
        }
    }

    protected final void args(String arg, FileSystemLocationProperty<? extends FileSystemLocation> fileProvider) {
        this.args(arg, fileProvider, false);
    }

    protected final void args(String arg, FileSystemLocationProperty<? extends FileSystemLocation> fileProvider, boolean locationOnly) {
        this.args(arg, locationOnly ? fileProvider.getLocationOnly() : fileProvider);
    }

    protected final void args(String arg, @UnknownNullability Provider<?> provider) {
        if (provider == null || !provider.isPresent()) {
            return;
        }
        Object value = provider.map(it -> it instanceof FileSystemLocation ? ((FileSystemLocation)it).getAsFile() : it).getOrNull();
        if (value == null) {
            return;
        }
        if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
            this.args(new Object[]{arg});
        } else {
            this.args(new Object[]{arg, String.valueOf(value)});
        }
    }

    protected final void args(Map<?, ?> args) {
        for (Map.Entry<?, ?> entry : args.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.args(key instanceof Provider ? (String)((Provider)key).map(Object::toString).get() : (String)this.getProviderFactory().provider(() -> key).map(Object::toString).get(), value instanceof Provider ? (Provider)value : this.getProviderFactory().provider(() -> value));
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    protected final void argOnlyIf(String arg, Provider<Boolean> onlyIf) {
        this.argOnlyIf(arg, task -> onlyIf.isPresent() && (Boolean)onlyIf.getOrElse((Object)false) != false);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    protected final void argOnlyIf(String arg, Spec<? super ToolExecBase<?>> onlyIf) {
        if (onlyIf.isSatisfiedBy((Object)this)) {
            this.args(new Object[]{arg});
        }
    }
}

